#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WVBoxLayout>
#include <Wt/WHBoxLayout>
#include <Wt/WGroupBox>
#include <Wt/WLabel>
#include <Wt/WText>
#include <Wt/WPushButton>
#include <iostream>


class WtApp : public Wt::WApplication
{
   public:
      WtApp( const Wt::WEnvironment& env);
      ~WtApp() {}


      void myHide()
      {
	 mHideDetails = !mHideDetails;
	 mMoreDetails->setHidden(mHideDetails);
      }

      void mySize()
      {
	 mainLayout_->setResizable(2, true, 500);
      }

   private:
      Wt::WText *createText(const Wt::WString& text);
      Wt::WWidget *createSelection();

      void vboxLayout();

   private:
      Wt::WContainerWidget* mSelections;
      Wt::WVBoxLayout* mSelectionLayout;
      Wt::WWidget* mDetails;
      Wt::WWidget* mMoreDetails;
      Wt::WText* mStretch;
      bool mHideDetails;
      Wt::WVBoxLayout* mainLayout_;
};

WtApp::WtApp(const Wt::WEnvironment& env)
   : Wt::WApplication(env)
   , mSelections(0)
   , mSelectionLayout(0)
   , mDetails(0)
   , mHideDetails(false)
{
   setCssTheme("polished");

   vboxLayout();
}

void WtApp::vboxLayout()
{
   Wt::WVBoxLayout* layout = new Wt::WVBoxLayout(root());

   root()->setLayout(layout);

   // row 0
   layout->addWidget(createText("Title"), 0, Wt::AlignTop);


   // row 1
   layout->addWidget(createText("SubTitle"), 0);

   // row 2
   Wt::WHBoxLayout* hbox  = new Wt::WHBoxLayout();
   hbox->addWidget(createSelection(), 0, Wt::AlignLeft);
   hbox->addWidget(createText("Main"), 1, Wt::AlignJustify);
   hbox->addWidget((mDetails = createText("Details")), 0, Wt::AlignJustify);
   hbox->setResizable(1, true);
   hbox->setSpacing(4);
   layout->addLayout(hbox, 3, Wt::AlignJustify);

   // row 3
   layout->addWidget((mMoreDetails = createText("More details")), 1);

   layout->setResizable(2, true);
   mainLayout_ = layout;
}

Wt::WText *WtApp::createText(const Wt::WString& text)
{
   Wt::WText *w = new Wt::WText(text);
   Wt::WCssDecorationStyle style;
   style.setBackgroundColor(Wt::WColor(200,200,200));
   w->setDecorationStyle(style);
   return w;
}

Wt::WWidget *WtApp::createSelection()
{
   mSelections = new Wt::WContainerWidget();
   Wt::WGroupBox *gbox1 = new Wt::WGroupBox("Test buttons");
   Wt::WPushButton* isize = new Wt::WPushButton("Use initialSize");
   Wt::WPushButton* hide = new Wt::WPushButton("Hide");
   isize->clicked().connect(this, &WtApp::mySize);
   hide->clicked().connect(this, &WtApp::myHide);
   gbox1->addWidget(hide);
   gbox1->addWidget(new Wt::WBreak());
   gbox1->addWidget(isize);

   mSelectionLayout = new Wt::WVBoxLayout();
   mSelectionLayout->setContentsMargins(4, 2, 4, 2);
   mSelectionLayout->addWidget(gbox1, 0, Wt::AlignTop);
   mSelectionLayout->addStretch(1);
   mSelections->setLayout(mSelectionLayout);
   return mSelections;
}


Wt::WApplication *createApplication(const Wt::WEnvironment& env)
{
   Wt::WApplication* myApplication = 0;
   myApplication = new WtApp( env );
   return myApplication;
}


int main(int argc, char **argv)
{
   Wt::WRun(argc, argv, &createApplication);
   return 0;
}
