

#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WTable>
#include <Wt/WTableCell>
#include <Wt/WText>


#include <string>
#include <iostream>
#include <boost/lexical_cast.hpp>

using namespace std;
using namespace Wt;

Wt::WApplication* WTableApp(const Wt::WEnvironment& env) {
    WApplication* app = new WApplication(env);
    WTable *table = new WTable(app->root());
    WTableCell *cell;
    for ( int row = 0; row < 3; ++row ) {
        for ( int col = 0; col < 4; ++col ) {
            cell = table->elementAt(row,col);
            cell->addWidget(new WText(boost::lexical_cast<string>(row) + "," + boost::lexical_cast<string>(col)));
        }
    }
    cout << "insertColumn(0);" << endl;
    table->insertColumn(0);
    table->resize(600,100);
    return app;
}

int main(int argc, char** argv) {
    return WRun(argc,argv,&WTableApp);
}

