#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WTable>
#include <Wt/WTableCell>
#include <Wt/WText>


#include <string>
#include <iostream>
#include <boost/lexical_cast.hpp>

using namespace std;
using namespace Wt;

Wt::WApplication* WTableApp(const Wt::WEnvironment& env) {
    WApplication* app = new WApplication(env);
    app->setCssTheme("polished");
    WTable *table = new WTable(app->root());
    table->resize(600,100);
    WTableCell *cell;
    for ( int row = 1; row < 3; ++row ) {
        for ( int col = 0; col < 4; ++col ) {
            cell = table->elementAt(row,col);
            cell->addWidget(new WText(boost::lexical_cast<string>(row) + "," + boost::lexical_cast<string>(col)));
        }
    }

    table->setHeaderCount(1);
    cell = table->elementAt(0,0);
    cell->setColumnSpan(table->columnCount());
    cell->addWidget(new WText("title"));

//    cout << "remove" << endl;
//    table->removeCell(0,0);
    cout << "moveColumn(0,2)" << endl;
    table->moveColumn(0,2);
//    cell = table->elementAt(0,0);
//    cell->addWidget(new WText("title"));
//    cell->setColumnSpan(table->columnCount());
    return app;
}

int main(int argc, char** argv) {
    return WRun(argc,argv,&WTableApp);
}

