#define BOOST_SIGNALS_NO_DEPRECATION_WARNING
#include <Wt/Dbo/Dbo>
#include <Wt/Dbo/backend/Sqlite3>
#include <string>

Wt::Dbo::Session * sesion;

struct meal : public Wt::Dbo::Dbo<meal>
{
    meal ()=default
    meal (meal&&)=default;
    long long ptr_id;
    std::string name;
    template<class A> void persist(A&a)
    {
        Wt::Dbo::field(a, name, "name");
    }
};

std::vector<meal> get_meals(void)
{
    Wt::Dbo::Transaction t {*sesion};
    std::cerr << "getting meals...\n";
    auto query = sesion->find<meal>();
    auto meals = query.resultList();
    std::vector<meal> ret;
    for (auto const & m : meals)
    {
        std::cerr << "meal with id " << m->id() << "\n";
        ret.push_back(std::move(*m.modify()));
        ret.back().ptr_id = m.id();
    }
    return ret;
}

meal get_meal(void)
{
    Wt::Dbo::Transaction t {*sesion};
    std::cerr << "getting meal...\n";
    auto query = sesion->find<meal>();
    auto meals = query.resultList();

    if (meals.size() <= 0)
        throw std::exception{};
    auto mealptr = meals.front();
    return std::move(*mealptr.modify());
}

int main()
{
    Wt::Dbo::backend::Sqlite3 db("meals.db");
    db.setProperty("show-queries", "true");
    Wt::Dbo::Session s;
    s.setConnection(db);
    s.mapClass<meal>("meal");
    sesion = &s;

    /*Get a single meal*/
    meal m { get_meal() };
    std::cerr << "GOT MEAL with id " << m.id() << ", name = " << m.name << '\n';



    auto const & meals = get_meals();
    std::cerr << "invalid id = " << Wt::Dbo::dbo_traits<meal>::invalidId() << '\n';
    for (auto const & m : meals)
    {
        std::cerr << "meal " << m.name << " has id " << m.id() << " and ptr_id = " << m.ptr_id << '\n';
    }
    return 0;

}
