// =====================================================================================
// 
//       Filename:  RoundedRectangleText.C
// 
//    Description:  
// 
//        Version:  1.0
//        Created:  2010年07月05日 11时40分38秒
//       Revision:  none
//       Compiler:  g++
// 
//         Author:  宋志民 (Song Zhi-Min), cszhmsong@gmail.com
//        Company:  希科系统开发小组(CxServer Development Group)
// 
// =====================================================================================

#include <WCssDecorationStyle>
#include <WBorder>

#include "RoundedRectangleText.h"

namespace Cs {

	RoundedRectangleText::RoundedRectangleText(const std::string& key, const WColor& border, 
											   const WColor& background, WContainerWidget *parent)
		: content_(),
		  border_(border),
		  background_(background),
		  WContainerWidget(parent) {
			
		WText *div1 = addDiv("rnd-rect-1");
		div1->decorationStyle().setBackgroundColor(border_);

		WText *div2 = addDiv("rnd-rect-2");
		WBorder div2_b;
		div2_b.setWidth(WBorder::Explicit, WLength(2));
		div2_b.setStyle(WBorder::Solid);
		div2_b.setColor(border_);
		div2->decorationStyle().setBorder(div2_b, Right | Left);

		WText *div3 = addDiv("rnd-rect-3");
		WBorder b;
		b.setWidth(WBorder::Explicit, WLength(1));
		b.setStyle(WBorder::Solid);
		b.setColor(border_);
		div3->decorationStyle().setBorder(b, Right | Left);

		WText *div4 = addDiv("rnd-rect-4");
		div4->decorationStyle().setBorder(b, Right | Left);

		content_ = new Text(key, "rnd-rect-content", this);
		content_->setInline(false);
		content_->decorationStyle().setBorder(b, Right | Left);
		content_->decorationStyle().setBackgroundColor(background_);

		WText *div4_ = addDiv("rnd-rect-4");
		div4_->decorationStyle().setBorder(b, Right | Left);

		WText *div3_ = addDiv("rnd-rect-3");
		div3_->decorationStyle().setBorder(b, Right | Left);

		WText *div2_ = addDiv("rnd-rect-2");
		div2_->decorationStyle().setBorder(div2_b, Right | Left);

		WText *div1_ = addDiv("rnd-rect-1");
		div1_->decorationStyle().setBackgroundColor(border_);
	}
	
	WText* RoundedRectangleText::addDiv(const std::string& style) {
		WText *div = new WText(this);
		div->setInline(false);
		div->setStyleClass(style);
		div->decorationStyle().setBackgroundColor(background_);
		return div;
	}

	WText* RoundedRectangleText::text() {
		return content_;
	}
}
