// =====================================================================================
// 
//       Filename:  RoundedRectangleText.h
// 
//    Description:  
// 
//        Version:  1.0
//        Created:  2010年07月05日 11时34分31秒
//       Revision:  none
//       Compiler:  g++
// 
//         Author:  宋志民 (Song Zhi-Min), cszhmsong@gmail.com
//        Company:  希科系统开发小组(CxServer Development Group)
// 
// =====================================================================================


#ifndef ROUNDEDRECTANGLE_TEXT_H_
#define ROUNDEDRECTANGLE_TEXT_H_

#include <WContainerWidget>
#include <WColor>
#include <WText>

#include "Text.h"

using namespace Wt;

namespace Cs {

/**
 * @addtogroup utils
 */
/*@{*/

	/*! \class RoundedRectangleText RoundedRectangleText.h "utils/RoundedRectangleText.h"
	 *  \brief Cs::RoundedRectangleText is an widget which uses rounded rectangle style.
	 */ 
	class RoundedRectangleText : public WContainerWidget {
	
		public:

			/*! \brief Creates an RoundedRectangleText with optional <i>parent</i> and text key.
		   	 */
		  	RoundedRectangleText(const std::string& key, const WColor& border, const WColor& background, 
								 WContainerWidget *parent = 0);

			/*! \brief Returns the text.
		   	 */
			WText* text();

		private:

			/*! \brief Adds a div.
		   	 */
			WText* addDiv(const std::string& style);

			Text  *content_;
			WColor border_;
			WColor background_;
	};
/*@}*/
}

#endif
