#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WHBoxLayout>
#include <Wt/WPushButton>

/*
 * A widget which which displays some buttons
 */
class MultiButtonWidget : public Wt::WContainerWidget
{
public:
  MultiButtonWidget()
  {
    num_buttons = 5;
    refresh();
  }

  /* clear container and create desired number of buttons */
  void refresh()
  {
    clear();

    Wt::WBoxLayout *hbox = new Wt::WHBoxLayout();
    setLayout(hbox);

    if( num_buttons++ > 7 )
      num_buttons = 0;

    for (int i=0; i < num_buttons; i++)
      {
	Wt::WString btn_text = Wt::WString("B{1}").arg(i+1);

	Wt::WPushButton *button = new Wt::WPushButton( btn_text );

	hbox->addWidget(button, 1);
      }
  }

private:
  int num_buttons;
};


/*
 * Our example application which extends WApplication
 */
class ExampleProgram: public Wt::WApplication
{
public:
  /* Constructor */
  ExampleProgram(const Wt::WEnvironment &env): Wt::WApplication(env)
  {
    setTitle("Example Program");

    MultiButtonWidget* panel = new MultiButtonWidget();
    
    Wt::WPushButton *button = new Wt::WPushButton("action");
    button->clicked().connect(std::bind([=] () { panel->refresh(); }));

    //populate the root container
    root()->addWidget(panel);
    root()->addWidget(button);
  }
};


/*
  Return a new WApplication
 */
Wt::WApplication* createApplication(const Wt::WEnvironment &env)
{
  return new ExampleProgram(env);
}


/*
  Start the application
 */
int main(int argc, char** argv)
{
  return Wt::WRun(argc, argv, &createApplication);
}
