#include <Wt/WApplication>
#include <Wt/WContainerWidget>

#include <Wt/WLineEdit>
#include <Wt/WMenu>
#include <Wt/WMessageBox>
#include <Wt/WNavigationBar>
#include <Wt/WPopupMenu>
#include <Wt/WPopupMenuItem>
#include <Wt/WStackedWidget>
#include <Wt/WText>
#include <Wt/WBootstrapTheme>

using namespace Wt;
using namespace std;

class RTLApplication : public WApplication {
public:
  RTLApplication(WEnvironment const & env);
};

RTLApplication::RTLApplication(WEnvironment const & env)
: WApplication(env) {

  setLayoutDirection(RightToLeft);

  messageResourceBundle().use("bootstrap_theme");
  setTheme(new WBootstrapTheme());
  useStyleSheet("css/style.css");

  setTitle("RTL Application");


  WContainerWidget * container = new WContainerWidget(root());
  container->setWidth(800);

  WNavigationBar * navigation = new WNavigationBar(container);
  navigation->setTitle("TITLE", "/");

  WStackedWidget * contentsStack = new WStackedWidget(container);
  contentsStack->addStyleClass("contents");

  WMenu * leftMenu = new WMenu(contentsStack, container);
  navigation->addMenu(leftMenu);

  leftMenu->addItem("Column 1", new WText("Column 1 content"));
  leftMenu->addItem("Column 2", new WText("Column 2 content"));
  leftMenu->addItem("Column 3", new WText("Column 3 content"));

  WMenu * rightMenu = new WMenu();
  navigation->addMenu(rightMenu, AlignRight);

  WPopupMenu * popup = new Wt::WPopupMenu();
  popup->addItem("Row 1");
  popup->addItem("Row 2");
  popup->addItem("Row 3");

  WMenuItem * item = new WMenuItem("rightMenu");
  item->setMenu(popup);
  rightMenu->addItem(item);

  WLineEdit *edit = new WLineEdit();
  edit->setEmptyText("Enter a search item");

  navigation->addSearch(edit, AlignRight);

  container->addWidget(contentsStack);

  root()->addWidget(container);
}

WApplication * createApplication(WEnvironment const & env) {
  return new RTLApplication(env);
}  

int main(int argc, char ** argv) {
  return WRun(argc, argv, &createApplication);
}
