#include <Wt/WApplication>
#include <Wt/WComboBox>
#include <Wt/WPushButton>
#include <Wt/WStandardItem>
#include <Wt/WStandardItemModel>
#include <Wt/WText>
#include <Wt/Chart/WCartesianChart>

using namespace Wt;

class TestApplication : public WApplication
{
public:
  TestApplication(const WEnvironment& env);
  ~TestApplication() { }
};

TestApplication::TestApplication(const WEnvironment& env) : WApplication(env)
{
  setTitle("WCartesianChart Tooltips");

  new WText("<h5>Press button to toggle between 0 and 2 points on chart.</h5>", root());

  auto button = new WPushButton("Press Three Times", root());

  auto chartModel = new WStandardItemModel(0, 2, this);

  Chart::WCartesianChart *chart = new Chart::WCartesianChart(Chart::ScatterPlot, root());
  chart->resize(200, 200);
  chart->setAutoLayoutEnabled();
  chart->setZoomEnabled();
  chart->setModel(chartModel);
  chart->setXSeriesColumn(0);
  chart->addSeries(Chart::WDataSeries(1, Chart::PointSeries));

  button->clicked().connect(std::bind([=] {
    if (chartModel->rowCount()) {
      chartModel->removeRows(0, 2);
    }
    else {
      chartModel->insertRows(0, 2);
      chartModel->setData(chartModel->index(0, 0), 1);
      chartModel->setData(chartModel->index(0, 1), 1);
      chartModel->setData(chartModel->index(0, 1), "tool tip one", ToolTipRole);
      chartModel->setData(chartModel->index(1, 0), 10);
      chartModel->setData(chartModel->index(1, 1), 10);
      chartModel->setData(chartModel->index(1, 1), "tool tip two", ToolTipRole);
    }
  }));
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return new TestApplication(env);});
}
