/*
 * AnimationTest.cpp
 *
 *    Created on: 11.02.2016
 *        Author: Stoycho Stefanov
 */


#include <Wt/WBoxLayout>
#include <Wt/WCompositeWidget>
#include <Wt/WHBoxLayout>
#include <Wt/WVBoxLayout>
#include <Wt/WPushButton>
#include <Wt/WStackedWidget>
#include <Wt/WCssDecorationStyle>
#include <Wt/WMenu>
#include <Wt/WText>
#include <Wt/WAnimation>
#include <Wt/WApplication>
#include <boost/bind.hpp>
using namespace Wt;
using namespace std;
#include <iostream>

void AppPathChange(const std::string& path ,WStackedWidget *Stack,WContainerWidget *Panel) {
    cout << "path "<< path << endl;
    if (path == "/panel") {
        Stack->setCurrentWidget(Panel);
    }
}


Wt::WApplication* WMyApp(const Wt::WEnvironment& env) {

    auto App(new WApplication(env));

    auto w = App->root();
    w->decorationStyle().setBackgroundColor(Wt::darkYellow);
    auto Layout = new WHBoxLayout();
    Layout->setContentsMargins(0,0,0,0);
    w->setLayout(Layout);

    auto Stack = new WStackedWidget();
    auto Menu = new WMenu(Stack, Vertical);
    Menu->setStyleClass("menu");
    Menu->setInternalPathEnabled();
    Menu->setInternalBasePath("/");

    WAnimation animation(WAnimation::Fade, WAnimation::Ease,500);
    Stack->setTransitionAnimation(animation);

    auto Panel(new WContainerWidget());

    auto PanelLayout = new WVBoxLayout();
    auto Page= new WContainerWidget();
    new WText("PanelContent",Page);
    Page->decorationStyle().setBackgroundColor(Wt::darkGreen);
    PanelLayout->addWidget(Page,1);
    Panel->setLayout(PanelLayout);

    auto Container = new WContainerWidget();
    Container->decorationStyle().setBackgroundColor(Wt::darkMagenta);
    new WText("Container",Container);
    Menu->addItem("Container",Container);

    auto Item = Menu->addItem("Panel",nullptr);
    Item->setPathComponent("panel");
    Stack->addWidget(Panel);
    App->internalPathChanged().connect(boost::bind(&AppPathChange,_1,Stack,Panel));

    Layout->addWidget(Menu,0);
    Layout->addWidget(Stack,1);
    Layout->setResizable(0, true);
    return App;
}

int main(int argc, char** argv) {
    cout << WT_CLASS << endl;
//    imcValueRangeZones Zones;
//    cout << MSGAT << "" << endl;
//    TestZonesFindingWithGaps();
//    TestSerialisation();
//    TestZonesSetBoundary();
//    cout << MSGAT << "" << endl;
//    return 0;
    return WRun(argc,argv,&WMyApp);
}
