#pragma once

#include	"Forward.h"

#include	"BaseContainers.h"
#include	"PaintedWidgets.h"

#include	<Wt/WContainerWidget>

namespace BitFactory 
{ 
	namespace UI { namespace Web
	{
		X_EXPORT Pixel::Scalar	Scrollbar();

		class ScrollbarHolder : public IInterface
		{
		public:
			virtual void ResizeScrollbars() = 0;
		};

		class X_EXPORT ScrollbarWidget : public Wt::WContainerWidget
		{
		public:
			ScrollbarWidget( const String& orientation, const std::vector< Wt::WWidget* >& toScroll, Wt::WContainerWidget* p = 0 );
			virtual void Resize( const Pixel::Scalar& viewed, const Pixel::Scalar& all ) = 0;
			Pixel::Scalar GetScrollOffset() const;
			void ScrollTo( const Pixel::Scalar& position );
		protected:
			void ResizeImpl( const Pixel::Size& viewed, const Pixel::Size& all );
		private:
			X_PIMPL_DECLARE;
		};

		class X_EXPORT HScrollbarWidget : public ScrollbarWidget
		{
		public:
			HScrollbarWidget( const std::vector< Wt::WWidget* >& toScroll, Wt::WContainerWidget* p = 0 );
			virtual void Resize( const Pixel::Scalar& viewed, const Pixel::Scalar& all ) override;
		};
			
		class X_EXPORT VScrollbarWidget : public ScrollbarWidget
		{
		public:
			VScrollbarWidget( const std::vector< Wt::WWidget* >& toScroll, Wt::WContainerWidget* p = 0 );
			virtual void Resize( const Pixel::Scalar& viewed, const Pixel::Scalar& all ) override;
		};
	}
}
}