#include	<Wt/WStandardItemModel>
#include	<Wt/WStandardItem>
#include	<Wt/WTableView>

namespace
{
	class TestPopupHeader
		: public Wt::WApplication
	{
	public:
		TestPopupHeader( const Wt::WEnvironment& env )
			: Wt::WApplication( env )
		{
		    root()->setAttributeValue( "oncontextmenu", "event.cancelBubble = true; event.returnValue = false; return false;" );

			Wt::WStandardItemModel* model = new Wt::WStandardItemModel( 0, 2 );
			model->setHeaderData( 0, Wt::Horizontal, std::string( "xxxxxxx" ) );
			model->setHeaderData( 1, Wt::Horizontal, std::string( "xxxxxxx" ) );
			for( auto i = 0; i < 1; i++ )
			{
				auto s = std::to_string( i );
				model->appendRow( { new Wt::WStandardItem( s + ", 0" ), new Wt::WStandardItem( s + ", 1" ) } );
			}

			auto t = new Wt::WTableView;
			t->setModel( model );
			t->setAlternatingRowColors( false );
			t->setSortingEnabled( false );
		    t->setSelectionMode( Wt::NoSelection );
			t->mouseWentUp().connect( SLOT( this, TestPopupHeader::ShowPopupMenu ) );
			t->setRowHeaderCount( 1 );
			root()->addWidget( t );
		}
		void ShowPopupMenu( const Wt::WModelIndex& item, const Wt::WMouseEvent& e )
		{
			Wt::WPopupMenu* popup = new Wt::WPopupMenu;
			popup->addItem( "x" );
			popup->popup( e );
		}
	};
}
