#include <Wt/WApplication>
#include <Wt/WStandardItemModel>
#include <Wt/WText>
#include <Wt/Chart/WCartesianChart>

using namespace Wt;

constexpr int POINT_COUNT = 2000;

class TestApplication : public WApplication
{
public:
  TestApplication(const WEnvironment& env);
  ~TestApplication() { }

private:
  Chart::WCartesianChart *chart_ = nullptr;
};

TestApplication::TestApplication(const WEnvironment& env) : WApplication(env)
{
  setTitle("WCartesianChart ToolTips CPU Usage Test");

  new WText("<h5>Move mouse over chart and observe logged output for cpu time. Worst case is pausing mouse where there is no marker</h5>", root());

  auto chartModel = new WStandardItemModel(POINT_COUNT, 2, this);

  for (int i = 0; i < POINT_COUNT; ++i) {
    chartModel->setData(chartModel->index(i, 0), rand() % 1000);
    chartModel->setData(chartModel->index(i, 1), rand() % 1000);
    chartModel->setData(chartModel->index(i, 1),
        std::string("Point number: ") + boost::lexical_cast<std::string>(i), ToolTipRole);
  }

  chart_ = new Chart::WCartesianChart(Chart::ScatterPlot, root());
  chart_->resize(1100, 500);
  chart_->setAutoLayoutEnabled();
  chart_->setZoomEnabled();
  chart_->setPanEnabled();
  chart_->setModel(chartModel);
  chart_->setXSeriesColumn(0);
  chart_->addSeries(Chart::WDataSeries(1, Chart::PointSeries));
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return new TestApplication(env);});
}
