#pragma once

#include <Wt/WRectF>

namespace Wt {
   namespace Chart {

//! \brief Abstract representation for a plane of data
//!
//! This class is used by WSpectrogramChart as the source for data to plot. It
//! can be discrete values or a continuous range, the latter requiring a custom
//! implementation. WDiscreteSpectogramData has been provided for convienience
//! with datasets having evenly spaced discrete values.
//!
//! \sa WDiscreteSpectrogramData
//!
class WAbstractSpectrogramData
{
public:
   WAbstractSpectrogramData(){}
   virtual ~WAbstractSpectrogramData(){}

   //! \brief Retrieves the value for a specific location
   virtual double  value( const double& x, const double& y ) = 0;
   //! \brief Determines the minimum and maximum values for the data to be ploted
   virtual void range( double& min, double& max ) = 0;
   //! \brief The rectangle of the data to be plotted
   virtual Wt::WRectF boundingRect() = 0;
};

   }
}

