#include "WLinearScaleEngine.h"
#include <Wt/WLength>

using namespace Wt;

namespace {

double round125(double v)
{
   double n = std::pow(10, std::floor(std::log10(v)));
   double msd = v / n;

   if (msd < 1.5)
      return n;
   else if (msd < 3.3)
      return 2*n;
   else if (msd < 7)
      return 5*n;
   else
      return 10*n;
}

const unsigned AUTO_LABEL_PIXELS = 50;
double calcAutoNumLabels(const WLength & axisSize)
{
  return axisSize.toPixels() / AUTO_LABEL_PIXELS;
}

}

namespace Wt {
   namespace Chart {

WLinearScaleEngine::WLinearScaleEngine(WObject * parent)
   : WAbstractScaleEngine(parent)
{
}

WLinearScaleEngine::~WLinearScaleEngine()
{
}

WAbstractScaleEngine::Ticks WLinearScaleEngine::generateTicks(double min, double max,const WLength& axisLength)
{
   static const double EPSILON = 1E-3;

   Ticks tks;

   double numLabels = calcAutoNumLabels(axisLength);
   double diff = max-min;
   diff = diff?diff:1;
   double renderInterval = round125( diff / numLabels);

   for (unsigned i = 0;; ++i) {
      double v = min + renderInterval * i;

      if (v - max > EPSILON * renderInterval)
         break;

      TickMark mark;
      mark.mark = i%2+1;
      mark.value = v;
      mark.pos = (v-min)/diff;
      tks.push_back( mark );
   }

   return tks;
}

double WLinearScaleEngine::transform( const double& in, const double& iMin, const double& iMax, const double& oMin, const double& oMax)
{
   //The ratio for position in source and destination is the same
   // ( x - x1 ) / ( x2 - x1 ) == ( y - y1 ) / ( y2 - y1 )
   // ( x - x1 )( y2 - y1 ) / ( x2 - x1 ) == ( y - y1 )
   return ( in - iMin ) * ( oMax - oMin ) / ( iMax - iMin ) + oMin;
}

double WLinearScaleEngine::invTransform( const double& in, const double& iMin, const double& iMax, const double& oMin, const double& oMax)
{
   //The ratio for position in source and destination is the same
   // ( x - x1 ) / ( x2 - x1 ) == ( y - y1 ) / ( y2 - y1 )
   // ( x - x1 )( y2 - y1 ) / ( x2 - x1 ) == ( y - y1 )
   return ( in - iMin ) * ( oMax - oMin ) / ( iMax - iMin ) + oMin;
}

   }
}

