//FIXME Not finished
// See also, WLinearScaleEngine

double transform( const double& in, const double& iMin, const double& iMax, const double& oMin, const double& oMax)
{
   // We take the log10 of the input number, but then to use the ratio
   // equation for the linear transform we also have to take the log10
   // of the bounds.  You will notice that this can be reduced to
   // log10( x/x1 )/log10( x2/x1 ) which is essentially a base modification
   // meaning logN( x/x1 )/logN( x2/x1 ) any logarithm can be used. The
   // transform is independant of the base.
   // ( log x - log x1 ) / ( log x2 - log x1 ) == ( y - y1 ) / ( y2 - y1 )
   // ( y2 - y1 ) ( log x - log x1 ) / ( log x2 - log x1 ) + y1 == y
   return ( oMax - oMin ) ( std::log(in) - std::log(iMin) ) / ( std::log(iMax) - std::log(iMin) ) + oMin;

}

double invTransform( const double& in, const double& iMin, const double& iMax, const double& oMin, const double& oMax)
{
   // We take the log10 of the input number, but then to use the ratio
   // equation for the linear transform we also have to take the log10
   // of the bounds.  You will notice that this can be reduced to
   // log10( x/x1 )/log10( x2/x1 ) which is essentially a base modification
   // meaning logN( x/x1 )/logN( x2/x1 ) any logarithm can be used. The
   // transform is independant of the base.
   // ( log x - log x1 ) / ( log x2 - log x1 ) == ( y - y1 ) / ( y2 - y1 )
   // log x - log x1 == ( log x2 - log x1 ) ( y - y1 ) / ( y2 - y1 )
   // log x == ( log x2 - log x1 ) ( y - y1 ) / ( y2 - y1 ) + log x1
   // x == e^( ( ln x2 - ln x1 ) ( y - y1 ) / ( y2 - y1 ) + ln x1 )
   // x == e^( ( ln x2 - ln x1 ) ( y - y1 ) / ( y2 - y1 ) ) + x1
   // x == ( e^( ( ln x2 - ln x1 ) ) ) ^ ( ( y - y1 ) / ( y2 - y1 ) ) + x1
   // x == ( e^ln( x2/x1 ) ) ^ ( ( y - y1 ) / ( y2 - y1 ) ) + x1
   // x == ( x2/x1 ) ^ ( ( y - y1 ) / ( y2 - y1 ) ) + x1
   return std::pow( oMax/oMin, (in-iMin)/(iMax-iMin) ) + oMin;
}
