#include "WNumericScale.h"
#include <boost/foreach.hpp>
#include <boost/format.hpp>

using namespace Wt;

namespace
{
   //! Axis title size
   const unsigned TSIZE = 15;
   //! Axis label size
   const unsigned LSIZE = 10;
}

namespace Wt {
   namespace Chart {

WNumericScale::WNumericScale( WObject * parent )
   : WAbstractScale( parent )
{
}

WNumericScale::~WNumericScale()
{
}

const WString & WNumericScale::title()
{
   return title_;
}

void WNumericScale::setTitle( const WString & t )
{
   title_ = t;
}

WLength WNumericScale::computedDepth()
{
   double pix = 0;
   pix += TSIZE; //Axis Title
   pix += 5; //Text compensation
   pix += LSIZE; //Label
   pix += 5; //Text compensation
   pix += 10;//Ticks
   return WLength(pix);
}

void WNumericScale::draw(Wt::WPainter& painter, WRectF& plotArea, const WAbstractScaleEngine::Ticks& ticks)
{
   //Title
   painter.save();
   {
      WFont font;
      font.setSize( WFont::FixedSize, TSIZE );
      //font.setFamily( WFont::SansSerif );
      painter.setFont( font );

      switch(side_)
      {
      case North:
         painter.translate(plotArea.left() + plotArea.width()/2,0);
         //painter.rotate( 0 );
         painter.drawText(-1,0,2,1,AlignCenter|AlignTop,title_);
         break;
      case East:
         painter.translate(plotArea.right() + computedDepth().toPixels(),plotArea.top() + plotArea.height()/2);
         painter.rotate( -90 );
         painter.drawText(-1,-1,2,1,AlignCenter|AlignBottom,title_);
         break;
      case South:
         painter.translate(plotArea.left() + plotArea.width()/2,plotArea.bottom() + computedDepth().toPixels());
         //painter.rotate( 0 );
         painter.drawText(-1,-1,2,1,AlignCenter|AlignBottom,title_);
         break;
      case West:
         painter.translate(0,plotArea.top() + plotArea.height()/2);
         painter.rotate( -90 );
         painter.drawText(-1,0,2,1,AlignCenter|AlignTop,title_);
         break;
      default:
         painter.drawText(0,0,1,1,AlignLeft|AlignTop,"Invalid Scale Orientation");
      }
   }
   painter.restore();
   //Ticks / Labels
   painter.save();
   {
      bool above = true;
      double size = 0;
      painter.translate( plotArea.left(), plotArea.bottom() );
      switch(side_)
      {
      case East:
         painter.translate( plotArea.width(), 0 );
         above = false;
      case West:
         painter.rotate( -90 );
         size = plotArea.height();
         break;

      case North:
         painter.translate( 0, plotArea.height() );
         size = plotArea.width();
         break;

      case South:
         above = false;
         size = plotArea.width();
         break;

      default:
         break;
      }

      BOOST_FOREACH( WAbstractScaleEngine::TickMark mark, ticks )
      {
         mark.pos *= size;
         drawTick( painter, mark, above );
      }
   }
   painter.restore();
}

void WNumericScale::drawTick( Wt::WPainter& painter, WAbstractScaleEngine::TickMark mark, bool above )
{
   painter.save();
   WPen pen( Wt::black );
   pen.setWidth( 2 );
   painter.setPen( pen );
   painter.drawLine( WPointF( mark.pos,0 ), WPointF( mark.pos, (above?-1:1) * 10 / (int)mark.mark ) );
   if(mark.mark==1)
   {
      std::string str = (boost::format( "%.4g" ) % mark.value).str();
      painter.drawText(mark.pos-1, (above?-1:1) * 11,2,1,AlignCenter|(above?AlignBottom:AlignTop),str);
   }
   painter.restore();
}

   }
}

