#include <Wt/WPaintedWidget>
#include <Wt/WRasterImage>
#include "WColorMap.h"
#include "WAbstractSpectrogramData.h"
#include "WAbstractScale.h"
#include "WAbstractScaleEngine.h"

namespace Wt {
   namespace Chart {

class WSpectrogramChart : public Wt::WPaintedWidget
{
public:
   enum Axis{ X_AXIS, Y_AXIS, Z_AXIS, NUM_AXIS };

   WSpectrogramChart( Wt::WContainerWidget * parent = 0 );
   ~WSpectrogramChart();

   //Get / Set Title(Ownership IS NOT TRANSFERED)
   const Wt::WString & title();
   void setTitle(const Wt::WString &);

   //Get / Set Palette(Ownership IS NOT TRANSFERED)
   WColorMap & colorMap();
   void setColorMap(WColorMap &);

   //Get / Set Data(Ownership IS NOT TRANSFERED)
   WAbstractSpectrogramData & data();
   void setData(WAbstractSpectrogramData &);

   //Get / Set an axis(Ownership IS NOT TRANSFERED)
   WAbstractScale * scale(Axis);
   void setScale(Axis, WAbstractScale *);

   //Get / Set an axis scale engine(Ownership IS NOT TRANSFERED)
   WAbstractScaleEngine * scaleEngine(Axis);
   void setScaleEngine(Axis, WAbstractScaleEngine *);

   //! Resize the chart itself, scaling the contents accordingly
   void resize(const Wt::WLength & width, const Wt::WLength & height);

   //! \brief Resize the chart so the plot area is the specified size
   void resizePlotArea(const Wt::WLength & width, const Wt::WLength & height);

protected:
   void paintEvent(Wt::WPaintDevice* paintDevice);

   //! Draw the chart
   void paint(Wt::WPainter& painter);

   //! Draw all the axis
   void drawAxes(Wt::WPainter& painter,Wt::WRectF& plotArea);

   //! Draw the plotArea onto the image to be sent
   void drawPlot(unsigned cols, unsigned rows) const;

   //! Draw the Z axis onto the cart
   void drawZ(unsigned cols) const;

   //! Remove me?
   void layoutSizeChanged(int width, int height);

   //! Compute how large the plot area is based on the size of the chart
   Wt::WRectF computePlotArea(Wt::WRectF area);

protected:
   Wt::WString               title_;
   Wt::WRasterImage        * plotImage_;
   Wt::WRasterImage        * zImage_;
   WColorMap               * colorMap_;
   WAbstractSpectrogramData * data_;
   WAbstractScale          * scale_       [NUM_AXIS];
   WAbstractScaleEngine    * scaleEngine_ [NUM_AXIS];
};

   }
}

