#pragma once

#include <Wt/WObject>
#include <Wt/WPainter>
#include "WAbstractScaleEngine.h"

namespace Wt {
   namespace Chart {

//! \brief Baseclass for an axis on a chart
class WAbstractScale : public Wt::WObject
{
public:
   enum Orientation { North, East, South, West, Custom };

   WAbstractScale( Wt::WObject * parent = 0 ) : Wt::WObject(parent) {}
   virtual ~WAbstractScale() {}

   //! \brief The computed space required
   //!
   //! \return The space from the chart side edge to the
   //!         top/bottom of the scale title (if present).
   virtual Wt::WLength computedDepth() = 0;

   //! \brief Draw the scale onto the chart
   //!
   //! \param painter Painter to use for drawing the axis
   //! \param plotArea The location of the contents, axis should *generally* be drawn around this area.
   //!
   virtual void draw(Wt::WPainter& painter, Wt::WRectF& plotArea, const WAbstractScaleEngine::Ticks& ticks) = 0;

   //! \brief Set the orientation of this axis
   //!
   //! \param side This side of the plotArea (N,E,S,W) that the axis should be drawn on
   virtual void setOrientation(Orientation side) {side_ = side;}

   //! \brief Retrieve the orientation of this axis
   //!
   //! \return Orientation of this axis
   virtual Orientation orientation() {return side_;}
protected:
   Orientation side_;
};

   }
}

