#pragma once

#include <Wt/WColor>

namespace Wt {
   namespace Chart {

//! The baseclass for a palette for a specrogram chart
class WColorMap
{
public:
   WColorMap(){}
   virtual ~WColorMap(){}

   //! \brief Retrieve a color from the palette for the chart
   //!
   //! \param value Value that needs a color
   //! \param min   Minimum possible value
   //! \param max   Maximum possible value
   //!
   //! \return The color for the requested value
   virtual Wt::WColor color(double value, double min, double max) = 0;
};

   }
}

