#include "WDiscreteSpectrogramData.h"

using namespace Wt;

namespace Wt {
   namespace Chart {

WDiscreteSpectrogramData::WDiscreteSpectrogramData(size_t width, size_t height, double xStep, double yStep)
   : xStep_(xStep), yStep_(yStep), iWidth_(width), iHeight_(height), xOffset_(0.0), yOffset_(0.0), data_(1,std::vector<double>(1))
{
}

WDiscreteSpectrogramData::~WDiscreteSpectrogramData()
{
}

WDiscreteSpectrogramData::Data2DArray & WDiscreteSpectrogramData::data()
{
   return data_;
}

double WDiscreteSpectrogramData::xOffset()
{
   return xOffset_;
}

double WDiscreteSpectrogramData::yOffset()
{
   return yOffset_;
}

void WDiscreteSpectrogramData::setXOffset( const double& offset )
{
   xOffset_ = offset;
}

void WDiscreteSpectrogramData::setYOffset( const double& offset )
{
   yOffset_ = offset;
}

void WDiscreteSpectrogramData::resize( size_t width, size_t height )
{
   if(height != iHeight_)
   {
      size_t cols = std::min( height, iHeight_ );
      for(size_t x = 0; x < cols; ++x)
      {
         data_[x].resize(height);
      }
   }

   //Remove or allocate columns
   data_.resize( width, std::vector<double>(height) );

   iWidth_  = width;
   iHeight_ = height;
}

double WDiscreteSpectrogramData::xStep()
{
   return xStep_;
}

double WDiscreteSpectrogramData::yStep()
{
   return yStep_;
}

void WDiscreteSpectrogramData::setStep( const double& xStep, const double& yStep )
{
   xStep_ = xStep;
   yStep_ = yStep;
}

void WDiscreteSpectrogramData::setStep( const double& step )
{
   xStep_ = step;
   yStep_ = step;
}

void WDiscreteSpectrogramData::setXStep( const double& step )
{
   xStep_ = step;
}

void WDiscreteSpectrogramData::setYStep( const double& step )
{
   yStep_ = step;
}

double WDiscreteSpectrogramData::value( const double& x, const double& y )
{
   double lx = x - xOffset_;
   double ly = y - yOffset_;

   size_t ax = lx / xStep_;
   size_t ay = ly / yStep_;

   //Double can round oddly, so if we are out of bounds,
   //it probably is not be a big deal.
   if( ax < 0 ) ax = 0;
   if( ay < 0 ) ay = 0;
   if( ax >= iWidth_ )  ax = iWidth_  - 1;
   if( ay >= iHeight_ ) ay = iHeight_ - 1;

   return data_[ax][ay];
}

void WDiscreteSpectrogramData::range( double& min, double& max )
{
   min = max = data_[0][0];

   for( size_t x = 0; x < iWidth_; ++x )
   {
      for( size_t y = 0; y < iHeight_; ++y )
      {
         double& val = data_[x][y];
         if( val < min ) min = val;
         if( val > max ) max = val;
      }
   }
}

WRectF WDiscreteSpectrogramData::boundingRect()
{
   return WRectF(xOffset_,yOffset_,iWidth_*xStep_,iHeight_*yStep_);
}

   }
}

