#pragma once

#include "WAbstractSpectrogramData.h"
#include <vector>

namespace Wt {
   namespace Chart {

//! \brief Representation for a plane of evenly spaced discrete data values
//!
//! This class is used by WSpectrogramChart as the source for data to plot. It
//! can be discrete values or a continuous range, the latter requiring a custom
//! implementation. WDiscreteSpectrogramData has been provided for convienience
//! with datasets having constant step sizes between values.
//!
//! \sa WAbstractSpectrogramData
//!
class WDiscreteSpectrogramData : public WAbstractSpectrogramData
{
public:
   WDiscreteSpectrogramData( size_t width = 1, size_t height = 1, double xStep = 1.0, double yStep = 1.0);
   virtual ~WDiscreteSpectrogramData();

   //! Backed by a vector of vectors
   typedef std::vector< std::vector<double> > Data2DArray;
   //! A reference to the data
   Data2DArray & data();
   //! Offset for the X axis, data not affected
   double xOffset();
   //! Offset for the Y axis, data not affected
   double yOffset();
   //! Offset for the X axis, data not affected
   void setXOffset( const double& offset );
   //! Offset for the Y axis, data not affected
   void setYOffset( const double& offset );
   //! Resize the data table
   void resize( size_t width, size_t height );
   //! The horizontal step size between values
   double xStep();
   //! The vertical step size between values
   double yStep();
   //! Set the horizontal & vertical step sizes between values
   void setStep( const double& xStep, const double& yStep );
   //! Set the horizontal & vertical step sizes between values to the same size
   void setStep( const double& step );
   //! The horizontal step size between values
   void setXStep( const double& step );
   //! The vertical step size between values
   void setYStep( const double& step );

   virtual double  value( const double& x, const double& y );
   virtual void range( double& min, double& max );
   virtual Wt::WRectF boundingRect();

protected:
   double xStep_, yStep_;
   size_t iWidth_, iHeight_;
   double xOffset_, yOffset_;
   Data2DArray data_;
};

   }
}

