#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WContainerWidget>
#include <Wt/WText>
#include <Wt/WPushButton>
#include <Wt/WMessageBox>
#include <Wt/WAnimation>
#include <Wt/WBootstrapTheme>

using namespace Wt;

class TestApplication : public WApplication {
public:
  TestApplication(const WEnvironment& env);
  void openMessageBox(WAnimation anim, std::string cover);
private:
  WBootstrapTheme theme_;
  WMessageBox *mb_ = nullptr;
};

void TestApplication::openMessageBox(WAnimation anim, std::string cover="")
{
  delete mb_;
  mb_ = new WMessageBox("WMessageBox",
      std::string("Test ") + (anim.empty() ? "without" : "with") + " animation",
      Information, Ok);
  if (!cover.empty())
    mb_->addStyleClass(cover);
  mb_->setHidden(false, anim);
  mb_->buttonClicked().connect(std::bind([=] {
    log("test_info") << "WMessageBox button clicked, message box is currently "
                     << (mb_->isHidden() ? "hidden" : "not hidden")
                     << ", about to setHidden(true, " << !anim.empty() << ")";
    mb_->setHidden(true, anim);
  }));
}

TestApplication::TestApplication(const WEnvironment& env) : WApplication(env)
{
  setTitle("Test of Dialog Cover with Animation");
  theme_.setVersion(WBootstrapTheme::Version3);
  setTheme(&theme_);
  styleSheet().addRule(".Wt-popup.workaround-cover.modal-backdrop", "background: rgba(0, 0, 0, 0.5);");
  

  new WText("<h3>Press buttons to open modal dialogs (WMessageBoxes).</h3>"
      "<p>Some issues:</p><ol>"
      "<li>Clicking on \"Ok\" will fail if pressed during the first two seconds on the slow animated dialog. Subsequent retries will also fail.</li>"
      "<li>Clicking on \"Ok\" continues to result in buttonClicked signals on the WMessageBox, even after it is hidden (from server perspective).</li>"
      "<li>All dialogs should have a gray dialog cover, but the default animated Bootstrap3 WMessageBox effectively has a black dialog cover.</li>"
      "<li>Minor: The time for the animated dialog cover to fade in is signifantly longer than the time set for the dialog to fade-in (possibly a feature?).</li>"
      "</ol>", root());

  (new WPushButton("Open WMessageBox (no animation)", root()))->clicked().connect(std::bind([=] {
    openMessageBox(WAnimation());
  }));

  (new WPushButton("Open WMessageBox (with slow animation)", root()))->clicked().connect(std::bind([=] {
    openMessageBox(WAnimation(WAnimation::Fade, WAnimation::Linear, 2000));
  }));

  (new WPushButton("Open WMessageBox (normal speed and cover workaround)", root()))->clicked().connect(std::bind([=] {
    openMessageBox(WAnimation(WAnimation::Fade, WAnimation::Linear), "workaround");
  }));

}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return new TestApplication(env);});
}
