#include <Wt/WServer>
#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WTabWidget>
#include <Wt/WTableView>
#include <Wt/WStandardItemModel>
#include <Wt/WStandardItem>
#include <Wt/WBootstrapTheme>

using namespace Wt;

class TableContainer : public WContainerWidget
{
public:
    TableContainer(WContainerWidget *parent = 0) : WContainerWidget(parent)
    {
        WTableView *table = new WTableView;

        WStandardItemModel *model = new WStandardItemModel(0, 7, this);

        table->setModel(model);
        table->setHeaderClickSortEnabled(true);
        table->setSelectionMode(Wt::SingleSelection);
        table->setSelectionBehavior(Wt::SelectRows);

        table->selectionChanged().connect(this, &TableContainer::onSelectionChanged);
        table->clicked().connect(this, &TableContainer::onClicked);

        table->setAlternatingRowColors(true);
        table->decorationStyle().setBorder(Wt::WBorder(), Wt::All);

        for (int i = 0; i < 40; ++i) {

            std::vector<WStandardItem*> row;
            for (int j = 0; j < 7; ++j)
                row.push_back(new WStandardItem("row"));

            model->appendRow(row);
        }

        addWidget(new Wt::WBreak);
        addWidget(table);
    }

    void onSelectionChanged()
    {
        printf("\n\tSELECTION CHANGED\n\n");
    }

    void onClicked()
    {
        printf("\n\tCLICKED\n\n");
    }
};

class TabContainer : public WContainerWidget
{
public:
    TabContainer(WContainerWidget *parent = 0) :  WContainerWidget(parent)
    {
        WTabWidget *tab = new WTabWidget(this);
        tab->setMaximumSize(700, Wt::WLength::Auto);

        tab->addTab(new TableContainer, "Tab");
        tab->addTab(new TableContainer, "Tab 2");
    }
};

class Test : public WApplication
{
public:
    Test(const WEnvironment& env) : Wt::WApplication(env)
    {
#if 1
        Wt::WBootstrapTheme *theme = new Wt::WBootstrapTheme();
        theme->setVersion(Wt::WBootstrapTheme::Version2);
        theme->setResponsive(true);
        setTheme(theme);
#endif
        root()->addStyleClass("container");
        root()->setContentAlignment(Wt::AlignCenter);

        root()->addWidget(new TabContainer);
    }
};

WApplication *createApplication(const WEnvironment& env)
{
    return new Test(env);
}

int main(int argc, char *argv[])
{
    return WRun(argc, argv, &createApplication);
}
