#include <Wt/WBootstrapTheme>
#include <Wt/WBreak>
#include <Wt/WEvent>
#include <Wt/WPopupMenu>
#include <Wt/WPushButton>
#include <Wt/WServer>
#include <Wt/WText>

using namespace Wt;

class TestApplication : public WApplication
{
public:
  TestApplication(const WEnvironment& env);

private:
  WBootstrapTheme bs_theme_;
  WPopupMenu *popup_ = nullptr;
  WContainerWidget *status_;
};

TestApplication::TestApplication(const WEnvironment& env) : WApplication(env)
{
  setTitle("WPopupMenu isHidden() inconsistency");
  setTheme(&bs_theme_);


  new WText("Press button to show WPopupMenu. Try dismissing by clicking outside or using auto-hide. "
      "Observe log below to verify that popup hidden status is consistent when button is pressed.", root());
  new WBreak(root());

  auto pb = new WPushButton("Press Me", root());
  pb->setStyleClass("btn-primary");

  status_ = new WContainerWidget(root());
  status_->resize(400,400);
  status_->setMargin(40, Top);
  status_->decorationStyle().setBackgroundColor(WColor("#eee"));
  status_->setOverflow(WContainerWidget::OverflowAuto);

  popup_ = new WPopupMenu();
  popup_->setAutoHide(true, 1000);
  WLink link("https://www.google.com");
  link.setTarget(TargetNewWindow);
  popup_ ->addItem("Visit google")->setLink(link);

  pb->clicked().connect(std::bind([this] (WMouseEvent event) {
    if (popup_ && !popup_->isHidden()) {
      new WText("<h5>popup is not hidden, ignoring</h5>", status_);
    }
    else {
      new WText("<h5>popup is hidden or non-existent, popup</h5>", status_);
      for (auto item: popup_->items())
        popup_->removeItem(item);
      WLink link("https://www.google.com");
      link.setTarget(TargetNewWindow);
      popup_ ->addItem("Visit google")->setLink(link);
      popup_->popup(event);
    }
    doJavaScript(status_->jsRef() + ".scrollTop = " + status_->jsRef() + ".scrollHeight;");
  }, std::placeholders::_1));
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return new TestApplication(env);});
}
