#include <Wt/WServer>
#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WContainerWidget>
#include <Wt/WDateEdit>
#include <Wt/WBootstrapTheme>
#include <Wt/WTabWidget>
#include <Wt/WComboBox>

using namespace Wt;


class Test : public WApplication
{
public:
    Test(const WEnvironment& env) : WApplication(env)
    {
        addMetaHeader(Wt::MetaName,"viewport", "width=device-width, initial-scale=1");

#if 1
        auto *theme = new WBootstrapTheme();
        theme->setVersion(WBootstrapTheme::Version2);
        theme->setResponsive(true);
        setTheme(theme);
#endif
        root()->addStyleClass("container");
        root()->setContentAlignment(Wt::AlignCenter);

        auto *t = new WTabWidget;

        WDateEdit *de1 = new WDateEdit;
        de1->setDate(WDate::currentDate());

        auto *c1 = new WContainerWidget;
        c1->addWidget(de1);

        t->addTab(c1, "tab 1");

        WDateEdit *de2 = new WDateEdit;
        de2->setDate(WDate::currentDate());

        auto *cb = new WComboBox;
        cb->addItem("item 1");
        cb->addItem("item 2");

        auto *c2 = new WContainerWidget;
        c2->addWidget(de2);
        c2->addWidget(new WBreak);
        c2->addWidget(cb);

        t->addTab(c2, "tab 2");

        root()->addWidget(t);
    }
};

WApplication *createApplication(const WEnvironment& env)
{
    return new Test(env);
}

int main(int argc, char *argv[])
{
    return WRun(argc, argv, &createApplication);
}
