#include <Wt/WServer>
#include <Wt/WIOService>
#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WTabWidget>
#include <Wt/WTableView>
#include <Wt/WCheckBox>
#include <Wt/WStandardItemModel>
#include <Wt/WStandardItem>
#include <Wt/WBootstrapTheme>

using namespace Wt;

class TableContainer : public WContainerWidget
{
    WCheckBox *cb;
    WStandardItemModel *model;
public:
    TableContainer(WContainerWidget *parent = 0) : WContainerWidget(parent)
    {
        cb = new WCheckBox("Toggle table size");

        WTableView *table = new WTableView;

        model = new WStandardItemModel(0, 1, this);
        populateModel();

        table->setModel(model);
        table->setSelectionMode(Wt::SingleSelection);
        table->setSelectionBehavior(Wt::SelectRows);

        table->setAlternatingRowColors(true);
        table->decorationStyle().setBorder(Wt::WBorder(), Wt::All);

        addWidget(cb);
        addWidget(new Wt::WBreak);
        addWidget(table);

        cb->changed().connect(this, &TableContainer::populateModel);
    }

private:
    void populateModel()
    {
        model->clear();

        int rowCount = cb->isChecked() ? 100 : 10;

        for (int i = 0; i < rowCount; ++i)
            model->appendRow(new WStandardItem(WString("row {1}").arg(i+1)));
    }
};

class Test : public WApplication
{
    WTabWidget *tabs = 0;

public:
    Test(const WEnvironment& env) : Wt::WApplication(env)
    {
#if 1
        Wt::WBootstrapTheme *theme = new Wt::WBootstrapTheme();
        theme->setVersion(Wt::WBootstrapTheme::Version2);
        setTheme(theme);

        root()->addStyleClass("container");
#endif
        setupUi();

#if 1
        enableUpdates();

        WServer::instance()->ioService().schedule(10 * 1000, [this]{
            WServer::instance()->post(this->sessionId(), std::bind(&Test::update, this));
        });
#endif
    }

private:
    void setupUi()
    {
        tabs = new WTabWidget;

        tabs->addTab(new TableContainer, "Tab 1");
        tabs->addTab(new TableContainer, "Tab 2");

        root()->addWidget(tabs);
    }

    void update()
    {
        delete tabs;
        setupUi();

        triggerUpdate();
    }
};

WApplication *createApplication(const WEnvironment& env)
{
    return new Test(env);
}

int main(int argc, char *argv[])
{
    return WRun(argc, argv, &createApplication);
}
