#ifndef HELLO_APPLICATION_H_
#define HELLO_APPLICATION_H_

#include "system/WQApplication"
#include <Wt/WVBoxLayout>
#include <Wt/WBootstrapTheme>
#include <Wt/WTable>
#include <Wt/WComboBox>

#include "Interface.hpp"

class Application : public Wt::WQApplication
{
public:
    explicit Application(const Wt::WEnvironment& env);
    ~Application();
    void viewReleased();
    static void getReleaseCommand(QString toBeReleasedSession, QString newOwnerToBeNotified);
    QString getSessionId() const;
    void localLoop();
    static void otherPeerReleasedCam(QString newOwnerToBeNotified);
    void itsTimeToBindCamera();
    std::shared_ptr<SingleView> getView() const;
protected:
    virtual void create();
    void start();
    virtual void destroy();
    void finalize();
    void unload();
private:
    void getProcessors();
private:
    bool _newInstance=false;
    Wt::WVBoxLayout _mainLayout;
    Wt::WBootstrapTheme _bootstrapTheme;
    akil::Streamer *_streamer;
    std::shared_ptr<SingleView> _view;
    akil::VideoAnalytics* _analytics=nullptr;
  //  Wt::WText _revisionInfo;
    uint _trackingWidth;
    QString _url;
    uint _fps;
    Wt::WTable _table;
    QHash<QString,akil::Camera> _processors;
    bool _okay=false;
    bool _once=false;
    akil::Camera::License _license;
    QString sessionId;
};

#endif // HELLO_APPLICATION_H_
