// WTable rendering bug (wt-4.0.0-rc2)
//
// Plateform :
//
//     Debian Jessie 64 bit
//     set(CMAKE_CXX_FLAGS "-Wall -Werror -std=c++11 -g -O0 -fno-inline")
//
// Steps to reproduce :
//
//     1. Load the web page
//     2. Click on "Push Me" button -> The first time, the table is correctly displayed
//     3. Reload the page with F5 (Firefox or Chromium)
//     4. Click on "Push Me" button -> The table is often wrongly displayed (lack of cell)

#include <Wt/WApplication.h>
#include <Wt/WEnvironment.h>
#include <Wt/WPushButton.h>
#include <Wt/WLabel.h>
#include <Wt/WText.h>
#include <Wt/WTable.h>
#include <Wt/WTableCell.h>
#include <Wt/WVBoxLayout.h>

class TestApplication : public Wt::WApplication
{
    public:
        TestApplication(const Wt::WEnvironment& env);
        ~TestApplication() { }
};

TestApplication::TestApplication(const Wt::WEnvironment& env) : Wt::WApplication(env)
{
    setTitle("Test");
    Wt::WVBoxLayout * ctn = new Wt::WVBoxLayout();
    root()->setLayout(std::unique_ptr <Wt::WLayout >(ctn));

    Wt::WTable * table = new Wt::WTable();
    table->addStyleClass("Wt-cal");
    ctn->addWidget(std::unique_ptr<Wt::WWidget>(table), 1);

    Wt::WPushButton * btn = new Wt::WPushButton("Push Me");
    ctn->addWidget(std::unique_ptr<Wt::WWidget>(btn));

    btn->clicked().connect([table](){
        for (int row = 1 ; row < 10 ; row++)
            for (int col = 0 ; col < 15 ; col++)
                table->elementAt(row, col)->addWidget(std::unique_ptr<Wt::WWidget>(new Wt::WLabel("Cell (" + std::to_string(row) + ", " + std::to_string(col) + ")")));
    });

    for (int col = 0 ; col < 15 ; col++)
        table->elementAt(0, col)->addWidget(std::unique_ptr<Wt::WWidget>(new Wt::WLabel("Header #" + std::to_string(col))));

    table->setHeaderCount(1);
}

int main(int argc, char **argv)
{
    return Wt::WRun(argc, argv, [](const Wt::WEnvironment& env) {
        return Wt::cpp14::make_unique<TestApplication>(env);
    });
}
