/*
 * Copyright (C) 2008 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */
#include <Wt/WApplication.h>
#include <Wt/WText.h>

#include "TreeViewExample.h"

using namespace Wt;

class TreeViewApplication: public WApplication
{
public:
  TreeViewApplication(const WEnvironment &env):
    WApplication(env)
  {
    std::unique_ptr<TreeViewExample> upWidget = cpp14::make_unique<TreeViewExample>(WString::tr("treeview-introduction"));
    pWidget = upWidget.get();
    root()->addWidget(std::move(upWidget));

    aboutDrink_ = root()->addWidget(cpp14::make_unique<WText>(""));
    internalPathChanged().connect(this, &TreeViewApplication::handlePathChange);
    this->handlePathChange();

    this->globalKeyPressed().connect([=]
    {
      if ( nullptr!=pWidget )
        pWidget->update();
    });
  }
private:
  WText *aboutDrink_;
  TreeViewExample *pWidget;

  void handlePathChange() {
    if (internalPathMatches("/drinks/")) {
      std::string drink = internalPathNextPart("/drinks/");
      aboutDrink_->setText(WString::tr("drink-" + drink));
    }
  }
};

std::unique_ptr<WApplication> createApplication(const WEnvironment& env)
{
  auto app = cpp14::make_unique<TreeViewApplication>(env);
  app->setTitle("WTreeView example");
  app->messageResourceBundle().use(WApplication::appRoot() + "drinks");
  app->styleSheet().addRule("button", "margin: 2px");
  app->useStyleSheet("wt.css");
  
  return std::move(app);
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}
