// This may look like C code, but it's really -*- C++ -*-
/*
 * Copyright (C) 2008 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */
#ifndef TREEVIEWEXAMPLE_H_
#define TREEVIEWEXAMPLE_H_

#include <Wt/WContainerWidget.h>
#include <Wt/WString.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/WTreeView.h>
#include <string>
#include <vector>

using namespace Wt;

enum WeatherIcon {
  Sun,
  SunCloud,
  Cloud,
  Rain,
  Storm,
  Snow
};

namespace Wt {
  class WStandardItem;
  class WStandardItemModel;
  class WTreeView;
  class WText;
}

class TreeViewModel : public WStandardItemModel
{
public:
  TreeViewModel();
  ~TreeViewModel() {};

  bool update();
  void toggleRowHeight(WTreeView *treeView_);
  void toggleStripes(WTreeView *treeView_);
  void toggleRoot(WTreeView *treeView_);
  void addRows(WTreeView *treeView_);

private:
  static std::unique_ptr<WStandardItem> continentItem(const std::string& continent);
  static std::unique_ptr<WStandardItem> countryItem(const std::string& country, const std::string& code);
  static std::vector<std::unique_ptr<WStandardItem> > cityItems(const std::string& city, WeatherIcon weather, const std::string& drink, bool useInternalPath, bool visited);

  WStandardItem *belgium_;
};

class TreeViewExample : public WContainerWidget
{
public:
  TreeViewExample(const WString& titleText);
  WTreeView *treeView() const { return treeView_; }
  bool update();

private:
  std::shared_ptr<WStandardItemModel> model_;
  WTreeView *treeView_;
};

#endif
