#if defined(HAVE_CONFIG_H)
    #include "config.h"
#endif

#include "IntegrationTestHelper.hpp"
#include <chrono>

BOOST_FIXTURE_TEST_SUITE(HttpSuite, IntegrationFixture)

BOOST_AUTO_TEST_CASE(simple_continuation_ignores_abort_writes_short_body)
{
    std::string payload{"HelloHelloHelloHelloHelloHelloHelloHelloHelloHello"};
    int success = 0;
    int failure = 0;
    int resets  = 0;
    for(int i=0; i!= 10000; ++i)
    {
        BOOST_TEST_CONTEXT("client: [" << i << "] of " << m_clients.size()<<" ")
        {
            BOOST_TEST_INFO("testing streaming download, aborting after headers ");
            BOOST_REQUIRE_EQUAL(i,require_http_get_url_scheduled("/test?stream=",eCancelledDownload));
            BOOST_REQUIRE_EQUAL(200,nth_msg(i).status());
            if(!nth_err(i))
            {
                ++success;
                BOOST_REQUIRE_EQUAL(boost::system::error_code(),nth_err(i));
                BOOST_REQUIRE_EQUAL(payload,nth_msg(i).body());
            }
            else
            {
                BOOST_REQUIRE((boost::asio::error::connection_reset  == nth_err(i)) || (boost::asio::error::operation_aborted == nth_err(i)));
                if(boost::asio::error::connection_reset  == nth_err(i))
                {
                    ++resets;
                    BOOST_REQUIRE(payload != nth_msg(i).body());
                }
                if(boost::asio::error::operation_aborted == nth_err(i))
                {
                    ++failure;
                    BOOST_REQUIRE_EQUAL(payload,nth_msg(i).body());
                    BOOST_REQUIRE(!nth_msg(i).body().empty());
                }
            }
        }
    }
    BOOST_REQUIRE_EQUAL(failure,aborted_count());
}
BOOST_AUTO_TEST_SUITE_END()
