#include <Wt/WDate>
#include <Wt/WPopupMenu>
#include <Wt/WComboBox>
#include <Wt/WPushButton>
#include <Wt/WTextArea>
#include <Wt/WDateEdit>
#include <Wt/WLineEdit>
#include <Wt/WText>
#include <Wt/WFileUpload>
#include <Wt/WProgressBar>
#include <Wt/WBreak>
#include "StoreModelFormView.h"

StoreModelFormView::StoreModelFormView(Session& session) :WTemplateFormView(), session_(session)
{
	setTemplateText(tr("template.store"));
	model_ = new StoreModel(session_, this);
	addFunction("id", &WTemplate::Functions::id);
	addFunction("block", &WTemplate::Functions::id);

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	Wt::WContainerWidget *container = new Wt::WContainerWidget();

	Wt::WFileUpload *fu = new Wt::WFileUpload(container);
	fu->setFileTextSize(50); // Set the width of the widget to 50 characters
	//fu->setProgressBar(new Wt::WProgressBar());
	fu->setMargin(10, Wt::Right);

	// Provide a button to start uploading.
	Wt::WPushButton *uploadButton = new Wt::WPushButton("Send");
	uploadButton->setMargin(10, Wt::Left | Wt::Right);

	Wt::WText *out = new Wt::WText(container);

	// Upload when the button is clicked.
	uploadButton->clicked().connect(std::bind([=]() {
		out->setText("File uploadButton is clicked.");
		fu->upload();
		uploadButton->disable();
	}));

	// React to a succesfull upload.
	fu->uploaded().connect(std::bind([=]() {
		out->setText("File upload is finished.");
	}));

	// React to a file upload problem.
	fu->fileTooLarge().connect(std::bind([=]() {
		out->setText("File is too large.");
	}));
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	entreprenuerCB_ = new Wt::WComboBox();
	entreprenuerCB_->setModel(model_->entreprenuerModel());
	/*entreprenuerCB->activated().connect(std::bind([=]() {
	std::string code = model_->entreprenuerCode(entreprenuerCB->currentIndex());
	model_->updateEntreprenuerModel(code);
	entreprenuerCB->setModel(model_->entreprenuerModel());
	model_->updateEnterpriseRecords(code);
	}));*/

	setFormWidget(StoreModel::entreprenuerField, entreprenuerCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showentreprenuer().toUTF8();
		int row = model_->entreprenuerModelRow(code);
		entreprenuerCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->entreprenuerCode(entreprenuerCB_->currentIndex());
		model_->setValue(StoreModel::entreprenuerField, code);
	});

	enterpriseCB_ = new Wt::WComboBox();
	enterpriseCB_->setModel(model_->enterpriseModel());

	setFormWidget(StoreModel::enterpriseField, enterpriseCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showenterprise().toUTF8();
		int row = model_->enterpriseModelRow(code);
		enterpriseCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->enterpriseCode(enterpriseCB_->currentIndex());
		model_->setValue(StoreModel::enterpriseField, code);
	});

	categoryCB_ = new Wt::WComboBox();
	categoryCB_->setModel(model_->categoryModel());
	categoryCB_->activated().connect(std::bind([=]() {
		std::string code = model_->categoryCode(categoryCB_->currentIndex());
		model_->updateSkuValues(code);
		skuCB_->setModel(model_->skuModel());
	}));

	setFormWidget(StoreModel::categoryField, categoryCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showcategory().toUTF8();
		int row = model_->categoryModelRow(code);
		categoryCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->categoryCode(categoryCB_->currentIndex());
		model_->setValue(StoreModel::categoryField, code);
	});

	//setFormWidget(StoreModel::categoryField, new Wt::WLineEdit());
	//model_->updateSkuValues();
	skuCB_ = new Wt::WComboBox();
	skuCB_->setModel(model_->skuModel());

	setFormWidget(StoreModel::skuField, skuCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showsku().toUTF8();
		int row = model_->skuModelRow(code);
		skuCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->skuCode(skuCB_->currentIndex());
		model_->setValue(StoreModel::skuField, code);
	});
	//setFormWidget(StoreModel::skuField, new Wt::WLineEdit());
	setFormWidget(StoreModel::actualpriceField, new Wt::WLineEdit());
	setFormWidget(StoreModel::discountField, new Wt::WLineEdit());
	setFormWidget(StoreModel::salepriceField, new Wt::WLineEdit());
	//setFormWidget(StoreModel::isfeaturedbrandField, new Wt::WLineEdit());
	featuredbrandCB_ = new Wt::WComboBox();
	featuredbrandCB_->setModel(model_->yesnoModel());
	setFormWidget(StoreModel::isfeaturedbrandField, featuredbrandCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showisfeaturedbrand().toUTF8();
		int row = model_->yesnoModelRow(code);
		featuredbrandCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->yesnoCode(featuredbrandCB_->currentIndex());
		model_->setValue(StoreModel::isfeaturedbrandField, code);
	});
	//setFormWidget(StoreModel::istrendingstyleField, new Wt::WLineEdit());
	trendingstyleCB_ = new Wt::WComboBox();
	trendingstyleCB_->setModel(model_->yesnoModel());
	setFormWidget(StoreModel::istrendingstyleField, trendingstyleCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showistrendingstyle().toUTF8();
		int row = model_->yesnoModelRow(code);
		trendingstyleCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->yesnoCode(trendingstyleCB_->currentIndex());
		model_->setValue(StoreModel::istrendingstyleField, code);
	});
	//setFormWidget(StoreModel::isnewarrivalField, new Wt::WLineEdit());
	newarrivalCB_ = new Wt::WComboBox();
	newarrivalCB_->setModel(model_->yesnoModel());
	setFormWidget(StoreModel::isnewarrivalField, newarrivalCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showisnewarrival().toUTF8();
		int row = model_->yesnoModelRow(code);
		newarrivalCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->yesnoCode(newarrivalCB_->currentIndex());
		model_->setValue(StoreModel::isnewarrivalField, code);
	});
	//setFormWidget(StoreModel::isdealField, new Wt::WLineEdit());
	dealCB_ = new Wt::WComboBox();
	dealCB_->setModel(model_->yesnoModel());
	setFormWidget(StoreModel::isdealField, dealCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showisdeal().toUTF8();
		int row = model_->yesnoModelRow(code);
		dealCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->yesnoCode(dealCB_->currentIndex());
		model_->setValue(StoreModel::isdealField, code);
	});
	//setFormWidget(StoreModel::istechdiscoveryField, new Wt::WLineEdit());
	techdiscoveryCB_ = new Wt::WComboBox();
	techdiscoveryCB_->setModel(model_->yesnoModel());
	setFormWidget(StoreModel::istechdiscoveryField, techdiscoveryCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showistechdiscovery().toUTF8();
		int row = model_->yesnoModelRow(code);
		techdiscoveryCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->yesnoCode(techdiscoveryCB_->currentIndex());
		model_->setValue(StoreModel::istechdiscoveryField, code);
	});
	setFormWidget(StoreModel::qtyField, new Wt::WLineEdit());
	setFormWidget(StoreModel::userField, new Wt::WLineEdit());
	setFormWidget(StoreModel::searchField, new Wt::WLineEdit());

	Wt::WString panelTitle = Wt::WString(tr("store-panelTitle"));
	Wt::WString formTitle = Wt::WString(tr("store-formTitle"));
	Wt::WString searchTitle = Wt::WString(tr("store-search"));
	Wt::WString searchLabel = Wt::WString(tr("store-searchcode"));

	Wt::WLineEdit *txtSearch = new Wt::WLineEdit();
	Wt::WPushButton *btnSearch = new Wt::WPushButton(tr("search"));
	btnSearch->clicked().connect(this, &StoreModelFormView::loadEntreprenuer);

	Wt::WPushButton *btnSave = new Wt::WPushButton(tr("save"));
	Wt::WPushButton *btnUpdate = new Wt::WPushButton(tr("update"));
	Wt::WPushButton *btnDelete = new Wt::WPushButton(tr("delete"));

	//button events
	btnSave->clicked().connect(this, &StoreModelFormView::saveStore);
	btnDelete->clicked().connect(this, &StoreModelFormView::deleteStore);

	Wt::WString colEntreprenuer = Wt::WString(tr("store-colEntreprenuer"));
	Wt::WString colEnterprise = Wt::WString(tr("store-colEnterprise"));
	Wt::WString colCategory = Wt::WString(tr("store-colCategory"));
	Wt::WString colSku = Wt::WString(tr("store-colSku"));
	Wt::WString colActualPrice = Wt::WString(tr("store-colActualPrice"));
	Wt::WString colDiscount = Wt::WString(tr("store-colDiscount"));
	Wt::WString colSalePrice = Wt::WString(tr("store-colSalePrice"));
	Wt::WString colIsFeaturedBrand = Wt::WString(tr("store-colIsFeaturedBrand"));
	Wt::WString colIsTrendingStyle = Wt::WString(tr("store-colIsTrendingStyle"));
	Wt::WString colIsNewArrival = Wt::WString(tr("store-colIsNewArrival"));
	Wt::WString colIsDeal = Wt::WString(tr("store-colIsDeal"));
	Wt::WString colIsTechDiscovery = Wt::WString(tr("store-colIsTechDiscovery"));
	Wt::WString colQty = Wt::WString(tr("store-colQty"));
	Wt::WString colUser = Wt::WString(tr("store-colUser"));

	bindString("panelTitle", panelTitle);
	bindString("formTitle", formTitle);
	bindString("searchTitle", searchTitle);
	bindString("searchLabel", searchLabel);

	bindWidget("btnSave", btnSave);
	bindWidget("btnUpdate", btnUpdate);
	bindWidget("btnDelete", btnDelete);
	bindWidget("status-info", new Wt::WText(""));
	bindWidget("btnSearch", btnSearch);
	bindWidget("search-info", new Wt::WText(""));
	bindWidget("image", fu);
	bindWidget("upload", uploadButton);

	bindString("colEntreprenuer", colEntreprenuer);
	bindString("colEnterprise", colEnterprise);
	bindString("colCategory", colCategory);
	bindString("colSku", colSku);
	bindString("colActualPrice", colActualPrice);
	bindString("colDiscount", colDiscount);
	bindString("colSalePrice", colSalePrice);
	bindString("colIsFeaturedBrand", colIsFeaturedBrand);
	bindString("colIsTrendingStyle", colIsTrendingStyle);
	bindString("colIsNewArrival", colIsNewArrival);
	bindString("colIsDeal", colIsDeal);
	bindString("colIsTechDiscovery", colIsTechDiscovery);
	bindString("colQty", colQty);
	bindString("colUser", colUser);

	table = new Wt::WTable();
	table->setHeaderCount(1);
	table->setWidth(Wt::WLength("100%"));

	table->elementAt(0, 0)->addWidget(new Wt::WText(tr("store-colSku")));
	table->elementAt(0, 1)->addWidget(new Wt::WText(tr("store-colActualPrice")));
	table->elementAt(0, 2)->addWidget(new Wt::WText(tr("store-colDiscount")));
	table->elementAt(0, 3)->addWidget(new Wt::WText(tr("store-colSalePrice")));
	table->elementAt(0, 4)->addWidget(new Wt::WText(" "));

	table->addStyleClass("table table-striped", true);

	bindWidget("table", table);

	updateView(model_);
	Wt::WComboBox *viewField =
		resolve<Wt::WComboBox*>(StoreModel::skuField);
	viewField->setFocus(true);

}

void StoreModelFormView::saveStore()
{
	updateModel(model_);

	if (model_->validate())
	{
		Wt::WText *response;

		try
		{
			dbo::Transaction transaction(session_);
			//check if the value exists
			dbo::ptr<Store> existStore = session_.find<Store>().where("sku_id = ?").bind(model_->showsku().toUTF8());

			if (!existStore)
			{
				std::cerr << "NEW: "  << std::endl;
				Store *store = new Store();

				store->entreprenuer = showentreprenuerPtr(model_->showentreprenuer().toUTF8());
				store->enterprise = showenterprisePtr(model_->showenterprise().toUTF8());
				store->sku = showskuPtr(model_->showsku().toUTF8());
				store->actualprice = model_->showactualprice().toUTF8();
				store->discount = model_->showdiscount().toUTF8();
				store->saleprice = model_->showsaleprice().toUTF8();
				store->isfeaturedbrand = model_->showisfeaturedbrand().toUTF8();
				store->istrendingstyle = model_->showistrendingstyle().toUTF8();
				store->isnewarrival = model_->showisnewarrival().toUTF8();
				store->isdeal = model_->showisdeal().toUTF8();
				store->istechdiscovery = model_->showistechdiscovery().toUTF8();
				store->qty = model_->showqty().toUTF8();

				dbo::ptr<Store> ptr = session_.add(store);

				response = new Wt::WText(tr("save-success"));
				response->addStyleClass("alert alert-success");
			}
			else
			{
				std::cerr << "UPDATE: " << std::endl;
				existStore.modify()->entreprenuer = showentreprenuerPtr(model_->showentreprenuer().toUTF8());
				existStore.modify()->enterprise = showenterprisePtr(model_->showenterprise().toUTF8());
				existStore.modify()->sku = showskuPtr(model_->showsku().toUTF8());
				existStore.modify()->actualprice = model_->showactualprice().toUTF8();
				existStore.modify()->discount = model_->showdiscount().toUTF8();
				existStore.modify()->saleprice = model_->showsaleprice().toUTF8();
				existStore.modify()->isfeaturedbrand = model_->showisfeaturedbrand().toUTF8();
				existStore.modify()->istrendingstyle = model_->showistrendingstyle().toUTF8();
				existStore.modify()->isnewarrival = model_->showisnewarrival().toUTF8();
				existStore.modify()->isdeal = model_->showisdeal().toUTF8();
				existStore.modify()->istechdiscovery = model_->showistechdiscovery().toUTF8();
				existStore.modify()->qty = model_->showqty().toUTF8();

				response = new Wt::WText(tr("update-success"));
				response->addStyleClass("alert alert-success");
			}

			showStoreRecords();
		}
		catch (Wt::Dbo::Exception &e)
		{
			std::cerr << "Dbo exception: " << e.what() << std::endl;
			response = new Wt::WText(tr("operation-failed"));
			response->addStyleClass("alert alert-danger");
		}
		catch (std::exception &e)
		{
			std::cerr << "exception: " << e.what() << std::endl;
			response = new Wt::WText(tr("operation-failed"));
			response->addStyleClass("alert alert-danger");
		}

		bindWidget("status-info", response);
		updateView(model_);

	}
	else
	{
		bindWidget("status-info", new Wt::WText(""));
		updateView(model_);
		std::cerr << "NOT VALID: " << std::endl;

	}
}

void StoreModelFormView::deleteStore()
{
	dbo::Transaction transaction(session_);

	Wt::WText *response;

	try
	{
		dbo::ptr<Store> ptr = session_.find<Store>().where("sku_id = ?").bind(model_->showsku().toUTF8());

		ptr.remove();
		model_->resetFields();

		entreprenuerCB_ = new Wt::WComboBox();
		entreprenuerCB_->setModel(model_->entreprenuerModel());
		/*entreprenuerCB->activated().connect(std::bind([=]() {
		std::string code = model_->entreprenuerCode(entreprenuerCB->currentIndex());
		model_->updateEntreprenuerModel(code);
		entreprenuerCB->setModel(model_->entreprenuerModel());
		model_->updateEnterpriseRecords(code);
		}));*/

		setFormWidget(StoreModel::entreprenuerField, entreprenuerCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showentreprenuer().toUTF8();
			int row = model_->entreprenuerModelRow(code);
			entreprenuerCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->entreprenuerCode(entreprenuerCB_->currentIndex());
			model_->setValue(StoreModel::entreprenuerField, code);
		});

		enterpriseCB_ = new Wt::WComboBox();
		enterpriseCB_->setModel(model_->enterpriseModel());

		setFormWidget(StoreModel::enterpriseField, enterpriseCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showenterprise().toUTF8();
			int row = model_->enterpriseModelRow(code);
			enterpriseCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->enterpriseCode(enterpriseCB_->currentIndex());
			model_->setValue(StoreModel::enterpriseField, code);
		});

		categoryCB_ = new Wt::WComboBox();
		categoryCB_->setModel(model_->categoryModel());
		categoryCB_->activated().connect(std::bind([=]() {
			std::string code = model_->categoryCode(categoryCB_->currentIndex());
			model_->updateSkuValues(code);
			skuCB_->setModel(model_->skuModel());
		}));

		setFormWidget(StoreModel::categoryField, categoryCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showcategory().toUTF8();
			int row = model_->categoryModelRow(code);
			categoryCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->categoryCode(categoryCB_->currentIndex());
			model_->setValue(StoreModel::categoryField, code);
		});

		//setFormWidget(StoreModel::categoryField, new Wt::WLineEdit());
		//model_->updateSkuValues();
		skuCB_ = new Wt::WComboBox();
		skuCB_->setModel(model_->skuModel());

		setFormWidget(StoreModel::skuField, skuCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showsku().toUTF8();
			int row = model_->skuModelRow(code);
			skuCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->skuCode(skuCB_->currentIndex());
			model_->setValue(StoreModel::skuField, code);
		});
		//setFormWidget(StoreModel::skuField, new Wt::WLineEdit());
		setFormWidget(StoreModel::actualpriceField, new Wt::WLineEdit());
		setFormWidget(StoreModel::discountField, new Wt::WLineEdit());
		setFormWidget(StoreModel::salepriceField, new Wt::WLineEdit());
		//setFormWidget(StoreModel::isfeaturedbrandField, new Wt::WLineEdit());
		featuredbrandCB_ = new Wt::WComboBox();
		featuredbrandCB_->setModel(model_->yesnoModel());
		setFormWidget(StoreModel::isfeaturedbrandField, featuredbrandCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showisfeaturedbrand().toUTF8();
			int row = model_->yesnoModelRow(code);
			featuredbrandCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->yesnoCode(featuredbrandCB_->currentIndex());
			model_->setValue(StoreModel::isfeaturedbrandField, code);
		});
		//setFormWidget(StoreModel::istrendingstyleField, new Wt::WLineEdit());
		trendingstyleCB_ = new Wt::WComboBox();
		trendingstyleCB_->setModel(model_->yesnoModel());
		setFormWidget(StoreModel::istrendingstyleField, trendingstyleCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showistrendingstyle().toUTF8();
			int row = model_->yesnoModelRow(code);
			trendingstyleCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->yesnoCode(trendingstyleCB_->currentIndex());
			model_->setValue(StoreModel::istrendingstyleField, code);
		});
		//setFormWidget(StoreModel::isnewarrivalField, new Wt::WLineEdit());
		newarrivalCB_ = new Wt::WComboBox();
		newarrivalCB_->setModel(model_->yesnoModel());
		setFormWidget(StoreModel::isnewarrivalField, newarrivalCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showisnewarrival().toUTF8();
			int row = model_->yesnoModelRow(code);
			newarrivalCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->yesnoCode(newarrivalCB_->currentIndex());
			model_->setValue(StoreModel::isnewarrivalField, code);
		});
		//setFormWidget(StoreModel::isdealField, new Wt::WLineEdit());
		dealCB_ = new Wt::WComboBox();
		dealCB_->setModel(model_->yesnoModel());
		setFormWidget(StoreModel::isdealField, dealCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showisdeal().toUTF8();
			int row = model_->yesnoModelRow(code);
			dealCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->yesnoCode(dealCB_->currentIndex());
			model_->setValue(StoreModel::isdealField, code);
		});
		//setFormWidget(StoreModel::istechdiscoveryField, new Wt::WLineEdit());
		techdiscoveryCB_ = new Wt::WComboBox();
		techdiscoveryCB_->setModel(model_->yesnoModel());
		setFormWidget(StoreModel::istechdiscoveryField, techdiscoveryCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showistechdiscovery().toUTF8();
			int row = model_->yesnoModelRow(code);
			techdiscoveryCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->yesnoCode(techdiscoveryCB_->currentIndex());
			model_->setValue(StoreModel::istechdiscoveryField, code);
		});
		setFormWidget(StoreModel::qtyField, new Wt::WLineEdit());
		setFormWidget(StoreModel::userField, new Wt::WLineEdit());
		setFormWidget(StoreModel::searchField, new Wt::WLineEdit());

		response = new Wt::WText(tr("deleted-record"));
		response->addStyleClass("alert alert-warning");

		showStoreRecords();
	}
	catch (Wt::Dbo::Exception &e)
	{
		std::cerr << "Dbo exception: " << e.what() << std::endl;
		response = new Wt::WText(tr("operation-failed"));
		response->addStyleClass("alert alert-danger");
	}
	catch (std::exception &e)
	{
		std::cerr << "exception: " << e.what() << std::endl;
		response = new Wt::WText(tr("operation-failed"));
		response->addStyleClass("alert alert-danger");
	}
}

void StoreModelFormView::showSelected(int index, dbo::ptr<Store>ptrStore, dbo::ptr<Sku>ptrSku)
{
	dbo::Transaction transaction(session_);
	Wt::WText *response;
	try 
	{

		categoryCB_ = new Wt::WComboBox();
		categoryCB_->setModel(model_->categoryModel());
		int category_ = model_->categoryModelRow(ptrSku->skucategory->skucategorycode);
		categoryCB_->setCurrentIndex(category_);
		categoryCB_->activated().connect(std::bind([=]() {
			std::string code = model_->categoryCode(categoryCB_->currentIndex());
			model_->updateSkuValues(code);
			skuCB_->setModel(model_->skuModel());
		}));

		setFormWidget(StoreModel::categoryField, categoryCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showcategory().toUTF8();
			int row = model_->categoryModelRow(code);
			categoryCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->categoryCode(categoryCB_->currentIndex());
			model_->setValue(StoreModel::categoryField, code);
		});

		//setFormWidget(StoreModel::categoryField, new Wt::WLineEdit());
		model_->updateSkuValues(ptrSku->skucategory->skucategorycode);
		skuCB_ = new Wt::WComboBox();
		skuCB_->setModel(model_->skuModel());
		int sku_ = model_->skuModelRow(ptrSku->skucode);
		skuCB_->setCurrentIndex(sku_);

		setFormWidget(StoreModel::skuField, skuCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showsku().toUTF8();
			int row = model_->skuModelRow(code);
			skuCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->skuCode(skuCB_->currentIndex());
			model_->setValue(StoreModel::skuField, code);
		});
		//setFormWidget(StoreModel::skuField, new Wt::WLineEdit());
		setFormWidget(StoreModel::actualpriceField, new Wt::WLineEdit(ptrStore->actualprice));
		setFormWidget(StoreModel::discountField, new Wt::WLineEdit(ptrStore->discount));
		setFormWidget(StoreModel::salepriceField, new Wt::WLineEdit(ptrStore->saleprice));
		//setFormWidget(StoreModel::isfeaturedbrandField, new Wt::WLineEdit());
		featuredbrandCB_ = new Wt::WComboBox();
		featuredbrandCB_->setModel(model_->yesnoModel());
		int feature_ = model_->yesnoModelRow(ptrStore->isfeaturedbrand);
		featuredbrandCB_->setCurrentIndex(feature_);
		setFormWidget(StoreModel::isfeaturedbrandField, featuredbrandCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showisfeaturedbrand().toUTF8();
			int row = model_->yesnoModelRow(code);
			featuredbrandCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->yesnoCode(featuredbrandCB_->currentIndex());
			model_->setValue(StoreModel::isfeaturedbrandField, code);
		});
		//setFormWidget(StoreModel::istrendingstyleField, new Wt::WLineEdit());
		trendingstyleCB_ = new Wt::WComboBox();
		trendingstyleCB_->setModel(model_->yesnoModel());
		int trend_ = model_->yesnoModelRow(ptrStore->istrendingstyle);
		trendingstyleCB_->setCurrentIndex(trend_);
		setFormWidget(StoreModel::istrendingstyleField, trendingstyleCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showistrendingstyle().toUTF8();
			int row = model_->yesnoModelRow(code);
			trendingstyleCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->yesnoCode(trendingstyleCB_->currentIndex());
			model_->setValue(StoreModel::istrendingstyleField, code);
		});
		//setFormWidget(StoreModel::isnewarrivalField, new Wt::WLineEdit());
		newarrivalCB_ = new Wt::WComboBox();
		newarrivalCB_->setModel(model_->yesnoModel());
		int arrival_ = model_->yesnoModelRow(ptrStore->isnewarrival);
		newarrivalCB_->setCurrentIndex(arrival_);
		setFormWidget(StoreModel::isnewarrivalField, newarrivalCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showisnewarrival().toUTF8();
			int row = model_->yesnoModelRow(code);
			newarrivalCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->yesnoCode(newarrivalCB_->currentIndex());
			model_->setValue(StoreModel::isnewarrivalField, code);
		});
		//setFormWidget(StoreModel::isdealField, new Wt::WLineEdit());
		dealCB_ = new Wt::WComboBox();
		dealCB_->setModel(model_->yesnoModel());
		int deal_ = model_->yesnoModelRow(ptrStore->isdeal);
		dealCB_->setCurrentIndex(deal_);
		setFormWidget(StoreModel::isdealField, dealCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showisdeal().toUTF8();
			int row = model_->yesnoModelRow(code);
			dealCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->yesnoCode(dealCB_->currentIndex());
			model_->setValue(StoreModel::isdealField, code);
		});
		//setFormWidget(StoreModel::istechdiscoveryField, new Wt::WLineEdit());
		techdiscoveryCB_ = new Wt::WComboBox();
		techdiscoveryCB_->setModel(model_->yesnoModel());
		int tech_ = model_->yesnoModelRow(ptrStore->istechdiscovery);
		techdiscoveryCB_->setCurrentIndex(tech_);
		setFormWidget(StoreModel::istechdiscoveryField, techdiscoveryCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showistechdiscovery().toUTF8();
			int row = model_->yesnoModelRow(code);
			techdiscoveryCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->yesnoCode(techdiscoveryCB_->currentIndex());
			model_->setValue(StoreModel::istechdiscoveryField, code);
		});
		setFormWidget(StoreModel::qtyField, new Wt::WLineEdit(ptrStore->qty));
		//setFormWidget(StoreModel::userField, new Wt::WLineEdit(ptrStore->user));
		//setFormWidget(StoreModel::searchField, new Wt::WLineEdit());

	}
	catch (Wt::Dbo::Exception &e)
	{
		std::cerr << "Dbo exception: " << e.what() << std::endl;
		response = new Wt::WText(tr("operation-failed"));
		response->addStyleClass("alert alert-danger");
	}
	catch (std::exception &e)
	{
		std::cerr << "exception: " << e.what() << std::endl;
		response = new Wt::WText(tr("operation-failed"));
		response->addStyleClass("alert alert-danger");
	}
}

void StoreModelFormView::showStoreRecords()
{
	updateModel(model_);

	table = new Wt::WTable();
	table->setHeaderCount(1);
	table->setWidth(Wt::WLength("100%"));

	table->elementAt(0, 0)->addWidget(new Wt::WText(tr("store-colSku")));
	table->elementAt(0, 1)->addWidget(new Wt::WText(tr("store-colActualPrice")));
	table->elementAt(0, 2)->addWidget(new Wt::WText(tr("store-colDiscount")));
	table->elementAt(0, 3)->addWidget(new Wt::WText(tr("store-colSalePrice")));
	table->elementAt(0, 4)->addWidget(new Wt::WText(" "));

	dbo::Transaction transaction(session_);

	ListStore lstStore = session_.find<Store>().where("enterprise_id = ?").bind(showenterprisePtr(model_->showenterprise().toUTF8()));

	std::cerr << "####################################### " << std::endl;
	std::cerr << "Entreprenuer Code: " << model_->showentreprenuer().toUTF8() << std::endl;
	std::cerr << "Enterprise Code: " << model_->showenterprise().toUTF8() << std::endl;
	std::cerr << "Enterprise id: " << showenterprisePtr(model_->showenterprise().toUTF8()).id() << std::endl;
	std::cerr << "lstStore Size: " << lstStore.size() << std::endl;
	std::cerr << "####################################### " << std::endl;
	int j = 1;

	for (ListStore::const_iterator i = lstStore.begin(); i != lstStore.end(); ++i)
	{
		table->elementAt(j, 0)->addWidget(new Wt::WText((*i)->sku->skuname));
		table->elementAt(j, 1)->addWidget(new Wt::WText((*i)->actualprice));
		table->elementAt(j, 2)->addWidget(new Wt::WText((*i)->discount));
		table->elementAt(j, 3)->addWidget(new Wt::WText((*i)->saleprice));

		Wt::WPushButton *btnSelect = new Wt::WPushButton(tr("select"));

		btnSelect->clicked().connect(boost::bind(&StoreModelFormView::showSelected, this, j, (*i), (*i)->sku));
		btnSelect->addStyleClass("btn btn-sm btn-info");
		table->elementAt(j, 4)->addWidget(btnSelect);

		j++;
	}

	table->addStyleClass("table table-striped", true);

	bindWidget("table", table);
}

void StoreModelFormView::loadEntreprenuer()
{
	updateModel(model_);//removed 07/08/2017 20:29

	dbo::Transaction transaction(session_);

	//enterpriseCB_ = new Wt::WComboBox();

	categoryCB_ = new Wt::WComboBox();
	categoryCB_->setModel(model_->categoryModel());
	categoryCB_->activated().connect(std::bind([=]() {
		std::string code = model_->categoryCode(categoryCB_->currentIndex());
		model_->updateSkuValues(code);
		skuCB_->setModel(model_->skuModel());
	}));

	setFormWidget(StoreModel::categoryField, categoryCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showcategory().toUTF8();
		int row = model_->categoryModelRow(code);
		categoryCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->categoryCode(categoryCB_->currentIndex());
		model_->setValue(StoreModel::categoryField, code);
	});

	//setFormWidget(StoreModel::categoryField, new Wt::WLineEdit());
	skuCB_ = new Wt::WComboBox();
	skuCB_->setModel(model_->skuModel());

	setFormWidget(StoreModel::skuField, skuCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showsku().toUTF8();
		int row = model_->skuModelRow(code);
		skuCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->skuCode(skuCB_->currentIndex());
		model_->setValue(StoreModel::skuField, code);
	});
	//setFormWidget(StoreModel::skuField, new Wt::WLineEdit());
	setFormWidget(StoreModel::actualpriceField, new Wt::WLineEdit());
	setFormWidget(StoreModel::discountField, new Wt::WLineEdit());
	setFormWidget(StoreModel::salepriceField, new Wt::WLineEdit()); 

	//setFormWidget(StoreModel::isfeaturedbrandField, new Wt::WLineEdit());
	featuredbrandCB_ = new Wt::WComboBox();
	featuredbrandCB_->setModel(model_->yesnoModel());
	setFormWidget(StoreModel::isfeaturedbrandField, featuredbrandCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showisfeaturedbrand().toUTF8();
		int row = model_->yesnoModelRow(code);
		featuredbrandCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->yesnoCode(featuredbrandCB_->currentIndex());
		model_->setValue(StoreModel::isfeaturedbrandField, code);
	});
	//setFormWidget(StoreModel::istrendingstyleField, new Wt::WLineEdit());
	trendingstyleCB_ = new Wt::WComboBox();
	trendingstyleCB_->setModel(model_->yesnoModel());
	setFormWidget(StoreModel::istrendingstyleField, trendingstyleCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showistrendingstyle().toUTF8();
		int row = model_->yesnoModelRow(code);
		trendingstyleCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->yesnoCode(trendingstyleCB_->currentIndex());
		model_->setValue(StoreModel::istrendingstyleField, code);
	});
	//setFormWidget(StoreModel::isnewarrivalField, new Wt::WLineEdit());
	newarrivalCB_ = new Wt::WComboBox();
	newarrivalCB_->setModel(model_->yesnoModel());
	setFormWidget(StoreModel::isnewarrivalField, newarrivalCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showisnewarrival().toUTF8();
		int row = model_->yesnoModelRow(code);
		newarrivalCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->yesnoCode(newarrivalCB_->currentIndex());
		model_->setValue(StoreModel::isnewarrivalField, code);
	});
	//setFormWidget(StoreModel::isdealField, new Wt::WLineEdit());
	dealCB_ = new Wt::WComboBox();
	dealCB_->setModel(model_->yesnoModel());
	setFormWidget(StoreModel::isdealField, dealCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showisdeal().toUTF8();
		int row = model_->yesnoModelRow(code);
		dealCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->yesnoCode(dealCB_->currentIndex());
		model_->setValue(StoreModel::isdealField, code);
	});
	//setFormWidget(StoreModel::istechdiscoveryField, new Wt::WLineEdit());
	techdiscoveryCB_ = new Wt::WComboBox();
	techdiscoveryCB_->setModel(model_->yesnoModel());
	setFormWidget(StoreModel::istechdiscoveryField, techdiscoveryCB_,
		[=]() { // updateViewValue()
		std::string code = model_->showistechdiscovery().toUTF8();
		int row = model_->yesnoModelRow(code);
		techdiscoveryCB_->setCurrentIndex(row);
	},
		[=]() { // updateModelValue()
		std::string code = model_->yesnoCode(techdiscoveryCB_->currentIndex());
		model_->setValue(StoreModel::istechdiscoveryField, code);
	});
	setFormWidget(StoreModel::qtyField, new Wt::WLineEdit());
	setFormWidget(StoreModel::userField, new Wt::WLineEdit());
	setFormWidget(StoreModel::searchField, new Wt::WLineEdit(model_->showsearch()));

	Wt::WText *searchResponse = new Wt::WText(" ");

	try
	{

		dbo::ptr<Entreprenuer> ptrEntreprenuer =
			session_.find<Entreprenuer>().where("entreprenuercode = ?").bind(model_->showsearch().toUTF8());

		std::cerr << "####################################### " << std::endl;
		std::cerr << "Found Entreprenuer: " << ptrEntreprenuer->entreprenuercode << std::endl;
		std::cerr << "####################################### " << std::endl;

		if (ptrEntreprenuer)
		{
			model_->updateEntreprenuerModel("" + ptrEntreprenuer->entreprenuercode);
			model_->updateEnterpriseModel("" + ptrEntreprenuer->entreprenuercode);

			searchResponse = new Wt::WText(tr("search-success"));
			searchResponse->addStyleClass("alert alert-success alert-dismissible");
		}
		else
		{
			searchResponse = new Wt::WText(tr("search-noresult"));
			searchResponse->addStyleClass("alert alert-info alert-dismissible");
		}

		//entreprenuerCB_ = new Wt::WComboBox();
		entreprenuerCB_->setModel(model_->entreprenuerModel());
		int entreprenuer_ = model_->entreprenuerModelRow(model_->showsearch().toUTF8());
		entreprenuerCB_->setCurrentIndex(entreprenuer_);

		setFormWidget(StoreModel::entreprenuerField, entreprenuerCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showentreprenuer().toUTF8();
			int row = model_->entreprenuerModelRow(code);
			entreprenuerCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->entreprenuerCode(entreprenuerCB_->currentIndex());
			model_->setValue(StoreModel::entreprenuerField, code);
		});

		enterpriseCB_->setModel(model_->enterpriseModel());
		int enterprise_ = model_->enterpriseModelRow(model_->showsearch().toUTF8());
		enterpriseCB_->setCurrentIndex(enterprise_);
		enterpriseCB_->activated().connect(std::bind([=]() {
		std::string code = model_->enterpriseCode(enterpriseCB_->currentIndex());
		std::cerr << "Enterprise Code" << code << std::endl;
		//model_->updateEnterpriseModel(code);
		enterpriseCB_->setModel(model_->enterpriseModel());
		//model_->updateEnterpriseRecords(code);
		showStoreRecords();
		}));

		setFormWidget(StoreModel::enterpriseField, enterpriseCB_,
			[=]() { // updateViewValue()
			std::string code = model_->showenterprise().toUTF8();
			int row = model_->enterpriseModelRow(code);
			enterpriseCB_->setCurrentIndex(row);
		},
			[=]() { // updateModelValue()
			std::string code = model_->enterpriseCode(enterpriseCB_->currentIndex());
			model_->setValue(StoreModel::enterpriseField, code);
		});

		updateModel(model_);

		showStoreRecords();
	}
	catch (Wt::Dbo::Exception &e)
	{
		std::cerr << "Dbo exception: " << e.what() << std::endl;

		searchResponse = new Wt::WText(tr("operation-failed"));

		searchResponse->addStyleClass("alert alert-danger");
	}
	catch (std::exception &e)
	{
		std::cerr << "exception: " << e.what() << std::endl;

		searchResponse = new Wt::WText(tr("operation-failed"));

		searchResponse->addStyleClass("alert alert-danger");
	}

	bindWidget("search-info", searchResponse); 

	updateView(model_);
}

dbo::ptr<Sku> StoreModelFormView::showskuPtr(std::string code)
{
	dbo::Transaction transaction(session_);

	dbo::ptr<Sku> ptr = session_.find<Sku>().where("skucode = ?").bind(code);

	return ptr;
}

dbo::ptr<Enterprise> StoreModelFormView::showenterprisePtr(std::string code)
{
	dbo::Transaction transaction(session_);

	dbo::ptr<Enterprise> ptr = session_.find<Enterprise>().where("enterprisecode = ?").bind(code);

	return ptr;
}

dbo::ptr<Entreprenuer> StoreModelFormView::showentreprenuerPtr(std::string code)
{
	dbo::Transaction transaction(session_);

	dbo::ptr<Entreprenuer> ptr = session_.find<Entreprenuer>().where("entreprenuercode = ?").bind(code);

	return ptr;
}

std::string StoreModelFormView::showskuname(dbo::ptr<Sku> ptr)
{
	dbo::Transaction transaction(session_);

	dbo::ptr<Store> storeptr = session_.find<Store>().where("enterprise_id = ?").bind(ptr.id());
	return storeptr->sku->skuname;
}

