// This may look like C code, but it's really -*- C++ -*-
/*
 * Copyright (C) 2010 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#ifndef PLANNER_CALENDAR_H_
#define PLANNER_CALENDAR_H_

#include "UserAccount.h" 

#include <Wt/Dbo/Dbo.h>
#include <Wt/WCalendar.h>
#include <Wt/WSignal.h>
#include <Wt/WDate.h>

using namespace Wt;

class PlannerCalendar : public WCalendar
{
public:
  PlannerCalendar(dbo::ptr<UserAccount> user);

  Signal<WString>& calendarWasModified() {return calendarModified_ ;} //TODO implement its now hard coded
  Signal<WString> calendarModified_;

  void onlyForDebuging() {std::cout << "Debug worked in PlannerCalendar" << std::endl; calendarModified_.emit("");}
protected:
  virtual WWidget* renderCell(WWidget* widget, const WDate& date) override;

private:
  void cellModified(const WString &str);

  dbo::ptr<UserAccount> user_;
};

#endif //PLANNER_CALENDAR_H_
