#include <Wt/WApplication.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WEnvironment.h>
#include <Wt/WStandardItem.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/WTableView.h>
#include <Wt/WTextArea.h>

class TestApplication : public Wt::WApplication {
public:
  TestApplication(const Wt::WEnvironment &env);
};

TestApplication::TestApplication(const Wt::WEnvironment &env)
    : WApplication(env) {
  using namespace Wt;

  auto table = std::make_unique<WTableView>();
  const Wt::WFlags<Wt::ItemFlag> zeroFlag;
  auto model = std::make_shared<WStandardItemModel>();
  int rows = 3;
  int cols = 3;
  for (auto i = 0; i < rows; ++i) {
    for (auto j = 0; j < cols; ++j) {
      auto item = cpp14::make_unique<WStandardItem>();
      item->setData(0, ItemDataRole::User);
      item->setData(i * j, ItemDataRole::Display);
      item->setFlags(ItemFlag::Editable | ItemFlag::Selectable);
      model->setItem(i, j, std::move(item));
    }
  }
  for (auto i = 0; i < cols; ++i) {
    model->setHeaderData(i, WString("Col {1}").arg(i));
  }
  table->setModel(model);

  table->setRowHeight(28);
  table->setHeaderHeight(28);
  table->setEditTriggers(EditTrigger::SingleClicked);
  table->setSortingEnabled(false);

  table->setSelectionBehavior(Wt::SelectionBehavior::Items);

  const int WIDTH = 120;
  for (auto i = 0; i < table->model()->columnCount(); ++i) {
    table->setColumnWidth(i, WIDTH);
    table->setColumnAlignment(i, Wt::AlignmentFlag::Right);
  }

  table->setWidth((WIDTH + 7) * table->model()->columnCount() + 2);

  root()->addWidget(std::move(table));
}

std::unique_ptr<Wt::WApplication>
createApplication(const Wt::WEnvironment &env) {
  return std::make_unique<TestApplication>(env);
}

int main(int argc, char **argv) {
  return Wt::WRun(argc, argv, &createApplication);
}
