#include <Wt/WApplication>
#include <Wt/WTreeView>
#include <Wt/WContainerWidget>
#include <Wt/WMessageResourceBundle>

class ResourceBundle : public Wt::WMessageResourceBundle
{
  public:
    virtual bool resolveKey (const std::string &key, std::string &result)
    {
      if (!Wt::WMessageResourceBundle::resolveKey (key,result))
        result = key;
      return true;
    }
};

class Test : public Wt::WApplication
{
  public:
    Test(const Wt::WEnvironment& env);
};

Test::Test(const Wt::WEnvironment& env)
    : Wt::WApplication(env)
{
  ResourceBundle* rb = new ResourceBundle();

  this->setLocalizedStrings(rb);
  rb->use (Wt::WApplication::appRoot() + "wt");
  this->root()->addWidget (new Wt::WTreeView());
}

Wt::WApplication* createApplication(const Wt::WEnvironment& env)
{
    return new Test(env);
}

int main(int argc, char *argv[])
{
   return Wt::WRun(argc, argv, &createApplication);
}
