#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WGridLayout>
#include <Wt/WText>
#include <Wt/WLineEdit>
#include <Wt/WVBoxLayout>
#include <Wt/WTabWidget>
using namespace Wt;

class TestWidget : public Wt::WContainerWidget
{
  public:
    TestWidget(Wt::WString text);
    virtual ~TestWidget() {}
    void add (WWidget*);
    WVBoxLayout*  m_layout;
};

TestWidget::TestWidget(Wt::WString text)
  : WContainerWidget(),m_layout(0)
{
  bool CREATE_PROBLEM = true;
  if (CREATE_PROBLEM)
  {
  // PROBLEM: Parent layout is not 70/30, it's completely wrong
    m_layout = new WVBoxLayout(this);
  }
}

void TestWidget::add(Wt::WWidget* widget)
{
  if (m_layout)
    m_layout->addWidget (widget);
  else
    this->addWidget (widget);
}

class Test : public WApplication
{
    public:
        Test(const Wt::WEnvironment& env);
};

Test::Test(const Wt::WEnvironment& env)
    : Wt::WApplication(env)
{
  WGridLayout* l = new WGridLayout(root());

  l->setColumnResizable (0,true);
  l->setColumnResizable (1,true);
  l->setColumnStretch(0,0);
  l->setColumnStretch(1,70);
  l->setColumnStretch(2,30);

  l->setRowStretch(0,0);
  l->setRowStretch(1,1);
  l->setRowStretch(2,0);

  l->addWidget (new Wt::WLineEdit (),1,1,Wt::AlignTop);

  Wt::WTabWidget* t (new Wt::WTabWidget (0));

  TestWidget* tw1 = new TestWidget("");
  Wt::WLineEdit* le = new Wt::WLineEdit();
  le->setText ("Test text");
  tw1->add (le);
  t->addTab(tw1,"Test",Wt::WTabWidget::PreLoading);

  TestWidget* tw2 = new TestWidget("");
  t->addTab(tw2,"Test",Wt::WTabWidget::PreLoading);

  l->addWidget (t,1,2,Wt::AlignTop);
}

WApplication* createApplication(const Wt::WEnvironment& env)
{
    return new Test(env);
}

int main(int argc, char *argv[])
{
   return Wt::WRun(argc, argv, &createApplication);
}
