#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WVBoxLayout>
#include <Wt/WPushButton>
#include <Wt/WBootstrapTheme>
#include <Wt/WPanel>

class CButtonWidget : public Wt::WContainerWidget
{
  public:
    CButtonWidget() : Wt::WContainerWidget() {}

    void addButton () { this->addWidget (new Wt::WPushButton("Test")); }
};

class CChooserWidget : public Wt::WContainerWidget {
  public:
    CChooserWidget() : Wt::WContainerWidget() {
      Wt::WVBoxLayout* l (new Wt::WVBoxLayout());
      this->setLayout(l);
      Wt::WPushButton* trigger (new Wt::WPushButton("Click Me"));
      l->addWidget (trigger);
      CButtonWidget* bw (new CButtonWidget());
      l->addWidget (bw);
      trigger->clicked().connect (bw,&CButtonWidget::addButton);
    }
};

class CPropertiesWidget : public Wt::WContainerWidget {
  public:
    CPropertiesWidget() : Wt::WContainerWidget() {
      Wt::WGridLayout* l (new Wt::WGridLayout());
      this->setLayout(l);
      Wt::WPanel* panel = new Wt::WPanel();
      panel->setCentralWidget(new CChooserWidget());
      panel->setCollapsible(false);
      panel->setCollapsed(false);
      panel->setTitleBar(false);
      l->addWidget (panel,0,0);
    }
};

class TestApp : public Wt::WApplication
{
  public:
    TestApp (const Wt::WEnvironment& env) : Wt::WApplication(env) {
      this->setTheme(new Wt::WBootstrapTheme(this));
      CPropertiesWidget* p (new CPropertiesWidget());
      this->root()->addWidget (p);
    }
};

Wt::WApplication* createApplication(const Wt::WEnvironment& env)
{
  return new TestApp(env);
}

int main(int argc, char *argv[])
{
  return Wt::WRun(argc, argv, &createApplication);
}
