/*
 * Attempt at minimal Wt with Qt WFileUpload recreate.
 */

#include "WQApplication.h"
#include <Wt/WContainerWidget>
#include <Wt/WEnvironment>
#include <Wt/WException>
#include <Wt/WFileUpload>
#include <Wt/WIOService>
#include <Wt/WProgressBar>
#include <Wt/WServer>
#include <Wt/WText>
#include <QCoreApplication>
#include <iostream>
#include <memory>


class UploadApp : public Wt::WQApplication
{
public:
    UploadApp(const Wt::WEnvironment &env)
    : Wt::WQApplication(env, true)
    , m_messages(nullptr)
    , m_upload(nullptr)
    {
    }

    ~UploadApp() = default;

    void create() override
    {
        m_messages = new Wt::WText(root());
        m_messages->setTextFormat(Wt::PlainText);
        m_messages->setText("Select a file to upload.");
        initFileUpload();
    }

    void destroy() override
    {
        root()->clear();
    }

private:
    void initFileUpload()
    {
        m_upload = new Wt::WFileUpload(root());
        m_upload->setProgressBar(new Wt::WProgressBar());
        m_upload->setMultiple(false); // only allow one file to be uploaded
        m_upload->changed().connect(
                    this, &UploadApp::handleUploadFileSelected);
        m_upload->uploaded().connect(
                    this, &UploadApp::handleUploadComplete);
        m_upload->fileTooLarge().connect(
                    this, &UploadApp::handleUploadFileTooLarge);
    }

    void handleUploadFileSelected()
    {
        m_messages->setText("commencing upload...\n");
        m_upload->upload();
    }

    void handleUploadComplete()
    {
        m_messages->setText("upload complete\n");
        // Avoid WFileUpload reuse
        root()->removeWidget(m_upload);
        delete m_upload;
        initFileUpload();
    }

    void handleUploadFileTooLarge()
    {
        m_messages->setText("error: file too large\n");
    }

    Wt::WText *m_messages;
    Wt::WFileUpload *m_upload;
};


// Web application factory function
Wt::WApplication *createApplication(const Wt::WEnvironment& env)
{
    return new UploadApp(env);
}

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
    const std::string wtConfigFile = "wtcfg.xml";
    const std::string httpdConfigFile = "httpd.conf";

    try {
        auto server = std::make_unique<Wt::WServer>(argv[0], wtConfigFile);
        server->setServerConfiguration(argc, argv, httpdConfigFile);
        server->addEntryPoint(Wt::Application, createApplication);
        server->ioService().setThreadCount(4);
        if (!server->start()) {
            std::cerr << "Error starting server.\n";
            return 1;
        } else {
            return Wt::WServer::waitForShutdown(argv[0]);
        }
    } catch (const Wt::WException &e) {
        std::cerr << "ERROR: " << e.what() << std::endl;
    }
}
