#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WHBoxLayout>
#include <Wt/WPushButton>
#include <Wt/WServer>
#include <Wt/WString>

#include <atomic>
#include <chrono>
#include <cstdint>
#include <functional>
#include <thread>

class Application final : public Wt::WApplication {
public:
  explicit Application(const Wt::WEnvironment &env)
    : WApplication(env),
      continue_(true),
      nextButtonId_(0),
      container_(new Wt::WContainerWidget())
  {
    enableUpdates(true);

    Wt::WHBoxLayout *layout = new Wt::WHBoxLayout();
    root()->setLayout(layout);

    layout->addWidget(container_, 1);
    addHiddenButtons();

    container_->mouseMoved().connect(std::bind([]{
      std::cout << "mouse moved\n";
    }));

    thread_ = std::thread(std::bind(&Application::run, this));
  }

  Application(const Application &) = delete;
  Application &operator=(const Application &) = delete;
  Application(Application&&) = delete;
  Application &operator=(Application&&) = delete;

  virtual ~Application() noexcept
  {
    continue_ = false;
    if (thread_.joinable()) {
      thread_.join();
    }
  }

  void run()
  {
    using namespace std::chrono_literals;
    while (continue_) {
      std::this_thread::sleep_for(30ms);
      UpdateLock lock(this);
      if (lock) {
        addHiddenButtons();
        triggerUpdate();
      }
    }
  }

  void addHiddenButtons()
  {
    container_->clear();

    for (int i = 0; i < 100; ++i) {
      Wt::WPushButton *button = new Wt::WPushButton(Wt::utf8("Button no. {1}").arg(nextButtonId_));
      ++nextButtonId_;
      button->setHidden(true);
      container_->addWidget(button);
    }
  }

private:
  std::atomic_bool continue_;
  std::thread thread_;
  std::uint64_t nextButtonId_;
  Wt::WContainerWidget * const container_;
};

int main(int argc, char *argv[])
{
  return Wt::WRun(argc, argv, [](const Wt::WEnvironment &env) {
    return new Application(env);
  });
}
