#include <Wt/WApplication.h>
#include <Wt/WEnvironment.h>
#include <Wt/WServer.h>
#include <Wt/WStandardItem.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/WTableView.h>
#include <Wt/WGridLayout.h>


using namespace Wt;

constexpr int GRID_ROWS = 5;
constexpr int GRID_COLS = 5;

class TableView : public WTableView {
public:
  TableView(int& instance_counter)
  {
    instance_ = ++instance_counter;

    setLayoutSizeAware(true);
    scrolled().connect([=] (WScrollEvent se) {
      log("info") << "TableView[" << instance_ << "] scrolled: scrollX: " << se.scrollX() << ", scrollY: " << se.scrollY()
                  << ", viewportWidth: " << se.viewportWidth() << ", viewportHeight: " << se.viewportHeight();
    });
  } 

  void layoutSizeChanged(int width, int height) override
  {
    log("info") << "TableView" << instance_ << "] layoutSizeChanged: (w = " << width << ", h = " << height << ")";
    WTableView::layoutSizeChanged(width, height);
  }

private:
  int instance_ = 0;
};

class TestApp : public WApplication {
public:
  TestApp(const WEnvironment& env);

private:
  std::vector<TableView *> tableViews_;
  int tableViewInstanceCounter_ = 0;
};

TestApp::TestApp(const WEnvironment& env) : WApplication(env)
{
  setTitle("WTableView scrollTo displays 'Loading'");

  auto topLayout = std::make_unique<WGridLayout>();

  auto model = std::make_shared<WStandardItemModel>(1000, 4);
  for (int r = 0; r < model->rowCount(); ++r) {
    for (int c = 0; c < model->columnCount(); ++c) {
      model->setData(model->index(r, c), r + c);
    }
  }

  for (int r = 0; r < GRID_ROWS; ++r) {
    for (int c = 0; c < GRID_COLS; ++c) {
      auto tableView = std::make_unique<TableView>(tableViewInstanceCounter_);
      auto tv = tableView.get();
      tableViews_.push_back(tv);
      tableView->setModel(model);
      topLayout->addWidget(std::move(tableView), r, c);
      tv->scrollTo(model->index(400, 0));
    }
  }

  root()->setLayout(std::move(topLayout));
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return std::make_unique<TestApp>(env);});
}
