#include <Wt/WApplication.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WPushButton.h>
#include <Wt/WJavaScript.h>
#include <Wt/WServer.h>
#include <Wt/WStringStream.h>

#include <functional>
#include <string>

constexpr const int STRING_SIZE = 2000000;

class Application : public Wt::WApplication {
public:
  Application(const Wt::WEnvironment &env);

private:
  Wt::JSignal<std::string> signal_;
};

Application::Application(const Wt::WEnvironment &env)
  : WApplication(env),
    signal_(this, "largeSignal")
{
  auto button = root()->addNew<Wt::WPushButton>(Wt::utf8("Send large signal"));

  Wt::WStringStream ss;
  ss << "function(){"
        "" "function randChar(){"
        ""   "var i=Math.floor(Math.random() * 26);"
        ""   "return String.fromCharCode(97+i);"
        "" "}"
        "" "var s='';"
        "" "while(s.length<" << STRING_SIZE << "){"
        ""   "s+=randChar();"
        "" "}"
        "" << signal_.createCall({"s"}) << ";"
        "}";

  button->clicked().connect(ss.str());

  signal_.connect([](const std::string &s){
    std::cout << "Received string, length: " << s.size() << '\n';
  });
}

int main(int argc, char *argv[])
{
  return Wt::WRun(argc, argv, [](const Wt::WEnvironment &env) {
    return std::make_unique<Application>(env);
  });
}
