#include <Wt/WApplication.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WEnvironment.h>
#include <Wt/WServer.h>
#include <Wt/WStandardItem.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/WTableView.h>
#include <Wt/WTimer.h>
#include <Wt/WFitLayout.h>


using namespace Wt;

class TableView : public WTableView {
public:
  TableView()
  {
    setLayoutSizeAware(true);
    scrolled().connect([=] (WScrollEvent se) {
      log("info") << "TableView scrolled: scrollX: " << se.scrollX() << ", scrollY: " << se.scrollY()
                  << ", viewportWidth: " << se.viewportWidth() << ", viewportHeight: " << se.viewportHeight();
    });
  } 

  void layoutSizeChanged(int width, int height) override
  {
    log("info") << "TableView layoutSizeChanged: (w = " << width << ", h = " << height << ")";
    WTableView::layoutSizeChanged(width, height);
  }
};

class TestApp : public WApplication {
public:
  TestApp(const WEnvironment& env);
};

TestApp::TestApp(const WEnvironment& env) : WApplication(env)
{
  setTitle("WTableView scrollTo displays 'Loading'");

  auto topLayout = std::make_unique<WFitLayout>();
  topLayout->setPreferredImplementation(LayoutImplementation::JavaScript);

  auto model = std::make_shared<WStandardItemModel>(1000, 4);
  for (int r = 0; r < model->rowCount(); ++r) {
    for (int c = 0; c < model->columnCount(); ++c) {
      model->setData(model->index(r, c), r + c);
    }
  }

  auto tableView = std::make_unique<TableView>();
  auto tv = tableView.get();
  tableView->setModel(model);
  topLayout->addWidget(std::move(tableView));

  root()->setLayout(std::move(topLayout));
//  enableUpdates();

  WTimer::singleShot(std::chrono::milliseconds(1000), std::bind([=] () {
    tv->scrollTo(model->index(400, 0));
  }));

  WTimer::singleShot(std::chrono::milliseconds(1050), std::bind([=] () {
    tv->scrollTo(model->index(800, 0));
  }));
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return std::make_unique<TestApp>(env);});
}
