#include <Wt/WApplication.h>
#include <Wt/WEnvironment.h>
#include <Wt/WServer.h>
#include <Wt/WStandardItem.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/WTimer.h>
#include <Wt/WTableView.h>
#include <Wt/WGridLayout.h>


using namespace Wt;

constexpr int GRID_ROWS = 4;
constexpr int GRID_COLS = 4;
constexpr int TIMER_INTERVAL_MS = 200;

class TableView : public WTableView {
public:
  TableView(int& instance_counter)
  {
    instance_ = ++instance_counter;

    setLayoutSizeAware(true);
    scrolled().connect([=] (WScrollEvent se) {
#if 0
      log("info") << "TableView[" << instance_ << "] scrolled: scrollX: " << se.scrollX() << ", scrollY: " << se.scrollY()
                  << ", viewportWidth: " << se.viewportWidth() << ", viewportHeight: " << se.viewportHeight();
#endif
    });
  } 

  void layoutSizeChanged(int width, int height) override
  {
#if 0
    log("info") << "TableView[" << instance_ << "] layoutSizeChanged: (w = " << width << ", h = " << height << ")";
#endif
    WTableView::layoutSizeChanged(width, height);
  }

private:
  int instance_ = 0;
};

class TestApp : public WApplication {
public:
  TestApp(const WEnvironment& env);

private:
  std::vector<TableView *> tableViews_;
  int tableViewInstanceCounter_ = 0;
};

TestApp::TestApp(const WEnvironment& env) : WApplication(env)
{
  setTitle("WTableView scrollTo displays 'Loading'");

  auto topLayout = std::make_unique<WGridLayout>();

  auto model = std::make_shared<WStandardItemModel>(1000, 4);
  for (int r = 0; r < model->rowCount(); ++r) {
    for (int c = 0; c < model->columnCount(); ++c) {
      model->setData(model->index(r, c), r + c);
    }
  }

  for (int r = 0; r < GRID_ROWS; ++r) {
    for (int c = 0; c < GRID_COLS; ++c) {
      auto tableView = std::make_unique<TableView>(tableViewInstanceCounter_);
      auto tv = tableView.get();
      tv->setSortingEnabled(false);
      tableViews_.push_back(tv);
      tableView->setModel(model);
      topLayout->addWidget(std::move(tableView), r, c);
    }
  }

  root()->setLayout(std::move(topLayout));

  int timer_ms = 1000;
  for (auto tv: tableViews_) {
    WTimer::singleShot(std::chrono::milliseconds(timer_ms), std::bind([=] () {
      tv->scrollTo(model->index(400, 0));
    }));
    timer_ms += TIMER_INTERVAL_MS;
  }
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return std::make_unique<TestApp>(env);});
}
