#include <Wt/WApplication.h>
#include <Wt/WAnimation.h>
#include <Wt/WEnvironment.h>
#include <Wt/WPushButton.h>
#include <Wt/WServer.h>
#include <Wt/WStackedWidget.h>
#include <Wt/WText.h>
#include <Wt/WVBoxLayout.h>


using namespace Wt;


class TestApp : public WApplication {
public:
  TestApp(const WEnvironment& env);

  WStackedWidget *stackedWidget_ = nullptr;
};

TestApp::TestApp(const WEnvironment& env) : WApplication(env)
{
  setTitle("WStackedWidget with animation affects overflow");

  auto stackedWidget = std::make_unique<WStackedWidget>();
  stackedWidget_ = stackedWidget.get();

  std::string longString = "<ol>";
  for (int i=1; i <= 1000; ++i)
    longString += "<li>test</li>";
  longString += "</ol>";

  auto container1 = std::make_unique<WContainerWidget>();
  auto container2 = std::make_unique<WContainerWidget>();
  container1->addNew<WText>("<h1>Tab 1</h1>" + longString);
  container2->addNew<WText>("<h1>Tab 2</h1>" + longString);
  container1->setOverflow(Overflow::Auto);
  container2->setOverflow(Overflow::Auto);

  // NOTE: Overflow works correctly if the following animation is disabled
#if 1
  stackedWidget_->setTransitionAnimation(
    WAnimation(AnimationEffect::Fade, TimingFunction::Linear, 500));
#endif

  stackedWidget->addWidget(std::move(container1));
  stackedWidget->addWidget(std::move(container2));

  auto pushButton = std::make_unique<WPushButton>("Push to toggle WStackedWidget");
  pushButton->clicked().connect([=] { stackedWidget_->setCurrentIndex((stackedWidget_->currentIndex() + 1) % 2); });

  auto topLayout = std::make_unique<WVBoxLayout>();
  topLayout->setPreferredImplementation(LayoutImplementation::JavaScript);

  topLayout->addWidget(std::move(pushButton), 0);
  topLayout->addWidget(std::move(stackedWidget), 1);
  root()->setLayout(std::move(topLayout));
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return std::make_unique<TestApp>(env);});
}
