
#include <Wt/WServer>
#include <Wt/WResource>
#include <Wt/Http/Client>
#include <Wt/Http/Request>
#include <Wt/Http/Response>
#include <Wt/Http/ResponseContinuation>

#include <memory>
#include <atomic>
#include <iostream>

// CMD:
// C:> server.exe --http-address 0.0.0.0 --docroot .

// Terminal (in parallel):
// $ while [ "$(curl -s 'http://localhost/FetchData')" == "done" ]; do   echo -n '.';   sleep 1; done

class FetchData : public Wt::WResource {
public:
   FetchData (Wt::WServer& server) : server(server) { }
   ~FetchData () override { beingDeleted(); }

  void handleRequest (const Wt::Http::Request& request, Wt::Http::Response& response) override
  {
    if (request.continuation()) {
      response.out().write("done", 4);
    } else {
      Wt::Http::ResponseContinuation *continuation = response.createContinuation();
      auto client = std::make_shared<Wt::Http::Client>();

      continuation->setData(client);

      client->done().connect([this, continuation] (boost::system::error_code err, const Wt::Http::Message& /*response*/, ...) {
         if (err) server.log("error") << err.message();
         continuation->haveMoreData();
      });

      if (client->get("http://localhost/Data")) {
        continuation->waitForMoreData();
      } else {
         server.log("error") << "something is wrong with the url";
      }
    }
  }

private:
   Wt::WServer& server;
};

class ServeData : public Wt::WResource {
public:
   ServeData () = default;
   ~ServeData () override { beingDeleted(); }

   void handleRequest (const Wt::Http::Request& /*request*/, Wt::Http::Response& /*response*/) override 
   {
   }
};







int main (int argc, char** argv)
try {
  Wt::WServer wserver{argc, argv};

  FetchData fetchdata(wserver);
  wserver.addResource(&fetchdata, "/FetchData");

  ServeData servedata;
  wserver.addResource(&servedata, "/Data");

  wserver.run();

  return 0;
}
catch (std::exception& e) {
  std::cerr << e.what() << std::endl;
  return 10;
}
 
