
#include <Wt/WServer>
#include <Wt/WResource>
#include <Wt/Http/Client>
#include <Wt/Http/Response>

#include <memory>
#include <atomic>
#include <iostream>

// CMD:
// C:> server.exe --http-address 0.0.0.0 --docroot .

// Terminal (in parallel):
// $ while [ "$(curl -s 'http://localhost/FetchData')" == "done" ]; do   echo -n '.';   sleep 1; done

class FetchData : public Wt::WResource {
public:
   FetchData () = default;
   ~FetchData () override { beingDeleted(); }

   void handleRequest (const Wt::Http::Request& /*request*/, Wt::Http::Response& response) override 
   {
      std::atomic<bool> done = false;
      auto client = std::make_unique<Wt::Http::Client>();

      client->done().connect([&] (boost::system::error_code err, const Wt::Http::Message& /*response*/, ...) {
         if (err) wApp->log("error") << err.message();
         done = true;
      });

      if (client->get("http://localhost/data")) {
         while (!done) {
            boost::this_thread::sleep_for(boost::chrono::milliseconds{25});
         }
      } 
      else {
         wApp->log("error") << "something is wrong with the url";
      }

      response.out().write("done", 4);
   }
};

class ServeData : public Wt::WResource {
public:
   ServeData () = default;
   ~ServeData () override { beingDeleted(); }

   void handleRequest (const Wt::Http::Request& /*request*/, Wt::Http::Response& /*response*/) override 
   {
   }
};







int main (int argc, char** argv) 
try {
   Wt::WServer wserver{argc, argv};

   FetchData fetchdata;
   wserver.addResource(&fetchdata, "/FetchData");

   ServeData servedata;
   wserver.addResource(&servedata, "/Data");

   wserver.run();

   return 0;
}
catch (std::exception& e) {
   std::cerr << e.what() << std::endl;
   return 10;
}
 
