#include <Wt/WApplication.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WEnvironment.h>
#include <Wt/WTemplate.h>
#include <Wt/WBootstrapTheme.h>
#include <Wt/WStackedWidget.h>

std::unique_ptr<Wt::WApplication> createApplication(const Wt::WEnvironment& env)
{
	std::unique_ptr<Wt::WApplication> app = std::make_unique<Wt::WApplication>(env);

	auto  bootstrapTheme = std::make_unique<Wt::WBootstrapTheme>();
	bootstrapTheme->setVersion(Wt::BootstrapVersion::v3);
	bootstrapTheme->setResponsive(true);
	app->setTheme(std::move(bootstrapTheme));

	static const std::string topLevelTemplateText =
R"(
<div class="container">
	<div class="jumbotron">
		${contents}
	</div>
</div>
)";

	static const std::string contentsTemplateText =
R"(
	<div class="form-horizontal">
		<div class="form-group">
			<label class="control-label col-sm-2">
				A description
			</label>
			<div class="col-sm-5 well well-sm">
				${desc}
			</div>
		</div>
	</div>
)";

	Wt::WTemplate* topLevel = app->root()->addNew<Wt::WTemplate>(topLevelTemplateText);

	Wt::WStackedWidget* mainStack = topLevel->bindNew<Wt::WStackedWidget>("contents");

	auto contents = std::make_unique<Wt::WTemplate>(contentsTemplateText);
	contents->bindString("desc", "Truncated desc. on small devices");

	mainStack->addWidget(std::move(contents));

	return app;
}

int main(int argc, char **argv)
{
	return Wt::WRun(argc, argv, &createApplication);
}
