
#include <Wt/WServer.h>
#include <Wt/WApplication.h>
#include <Wt/WEnvironment.h>

#include <Wt/WContainerWidget.h>
#include <Wt/WVBoxLayout.h>
#include <Wt/WPushButton.h>
#include <Wt/WCssDecorationStyle.h>

class MyApp : public Wt::WApplication {

   Wt::WVBoxLayout* innerLayout{nullptr};

   void Reset () 
   {
      while (innerLayout->count()) {
         innerLayout->removeItem(innerLayout->itemAt(innerLayout->count() -1));
      }

      auto container = innerLayout->addWidget(std::make_unique<Wt::WContainerWidget>(), 1);
      container->decorationStyle().setBackgroundColor(Wt::StandardColor::Green);
   }

public:
   MyApp(const Wt::WEnvironment& e) 
    : Wt::WApplication(e)
   {
      auto layout = root()->setLayout(std::make_unique<Wt::WVBoxLayout>());
      auto button = layout->addWidget(std::make_unique<Wt::WPushButton>("reset"));
      button->clicked().connect(this, &MyApp::Reset);

      auto innerContainer = layout->addWidget(std::make_unique<Wt::WContainerWidget>(), 1);
      innerLayout = innerContainer->setLayout(std::make_unique<Wt::WVBoxLayout>());

      Reset();
   }

   static std::unique_ptr<MyApp> Instance (const Wt::WEnvironment& env) 
   {
      return std::make_unique<MyApp>(env);
   }
};


int main (int argc, char** argv) 
try {
   Wt::WServer wserver{argc, argv};

   Wt::WLayout::setDefaultImplementation(Wt::LayoutImplementation::JavaScript);

   wserver.addEntryPoint(Wt::EntryPointType::Application, &MyApp::Instance);
   wserver.run();

   return 0;
}
catch (std::exception& e) {
   std::cerr << e.what() << std::endl;
   return 10;
}
 
