#include <Wt/WApplication.h>
#include <Wt/WEnvironment.h>
#include <Wt/WServer.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/WTableView.h>
#include <Wt/WText.h>
#include <Wt/WVBoxLayout.h>

using namespace Wt;


class TestApp : public WApplication {
public:
  TestApp(const WEnvironment& env);
};

TestApp::TestApp(const WEnvironment& env) : WApplication(env)
{
  setTitle("WTableView scrollTo failures (intermittent)");

  auto topLayout = root()->setLayout(std::make_unique<WVBoxLayout>());

  auto model = std::make_shared<WStandardItemModel>(2000, 4);
  auto keyModel = std::make_shared<WStandardItemModel>(20, 1);

  for (int r = 0; r < keyModel->rowCount(); ++r)
    keyModel->setData(keyModel->index(r, 0), (r * 100) % model->rowCount());

  for (int r = 0; r < model->rowCount(); ++r)
    for (int c = 0; c < model->columnCount(); ++c)
      model->setData(model->index(r, c), r + c);

  topLayout->addWidget(std::make_unique<WText>(
    "Selections in top table view select/scroll bottom tableview(s)."
    "Try manually scrolling lower tableviews to top/bottom of range before making selections in top table view."
    "Look for intermittent scroll failures. Use a window of 600px vertical height or more...."
  ));
  auto tvk = topLayout->addWidget(std::make_unique<WTableView>(), 0);
  tvk->setModel(keyModel);
  tvk->setSelectionMode(SelectionMode::Single);
  tvk->setHeight(WLength(200));

  std::vector<WTableView *> tvs;
  for (int i = 0; i < 2; ++i) {
    auto tv = topLayout->addWidget(std::make_unique<WTableView>(), 1);
    tv->setModel(model);
    tv->setSelectionMode(SelectionMode::Single);

    // OPTIONAL: use setPreloadMargin to make the error easier to reproduce
    tv->setPreloadMargin(2000);
    tvs.push_back(tv);
  }

  tvk->selectionChanged().connect([=] {
    int row = -1;
    if (tvk->selectedIndexes().size() == 1) {
      row = cpp17::any_cast<int>(keyModel->data(*tvk->selectedIndexes().begin(), 0));
      for (auto tv: tvs) {
        auto mi = model->index(row, 0);
        tv->select(mi);
        tv->scrollTo(mi, ScrollHint::PositionAtCenter);
      }
    }
  });

  tvk->select(keyModel->index(5, 0));
}

int main(int argc, char **argv)
{
  WLayout::setDefaultImplementation(LayoutImplementation::JavaScript);
  return WRun(argc, argv, [](const WEnvironment& env) {return std::make_unique<TestApp>(env);});
}
